/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.util.concurrent.MovingAverageTask;
import java.util.concurrent.Callable;

public class DeltaMovingAverageTask
extends MovingAverageTask {
    private double oldValue = 0.0;

    public DeltaMovingAverageTask(String name, Callable<? extends Number> sampleTask) {
        super(name, sampleTask);
    }

    public DeltaMovingAverageTask(String name, Callable<? extends Number> sampleTask, double w) {
        super(name, sampleTask, w);
    }

    @Override
    public void run() {
        try {
            double sample = ((Number)this.sampleTask.call()).doubleValue();
            double delta = sample - this.oldValue;
            this.oldValue = sample;
            this.average = DeltaMovingAverageTask.getMovingAverage(this.average, delta, this.w);
            ++this.nsamples;
        }
        catch (Exception ex) {
            log.warn((Object)this.name, (Throwable)ex);
        }
    }
}

