/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.config;

import com.bigdata.attr.ServiceInfo;
import com.bigdata.util.config.NicUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;

public class ConfigDeployUtil {
    private static Properties deploymentProps = null;
    private static final String DEFAULT = ".default";
    private static final String STRINGVALS = ".stringvals";
    private static final String MAX = ".max";
    private static final String MIN = ".min";
    private static final String DESCRIPTION = ".description";
    private static final String TYPE = ".type";

    public static String getString(String parameter) throws ConfigurationException {
        String value = ConfigDeployUtil.get(parameter);
        ConfigDeployUtil.validateString(parameter, value);
        return value;
    }

    public static String[] getStringArray(String parameter) throws ConfigurationException {
        String[] value = ConfigDeployUtil.validateStringArray(parameter, ConfigDeployUtil.get(parameter));
        return value;
    }

    public static int getInt(String parameter) throws ConfigurationException {
        int value = ConfigDeployUtil.validateInt(parameter, ConfigDeployUtil.get(parameter));
        return value;
    }

    public static long getLong(String parameter) throws ConfigurationException {
        long value = ConfigDeployUtil.validateLong(parameter, ConfigDeployUtil.get(parameter));
        return value;
    }

    public static boolean getBoolean(String parameter) throws ConfigurationException {
        String value;
        boolean boolValue = false;
        try {
            value = ConfigDeployUtil.get(parameter);
        }
        catch (Exception ex) {
            throw new ConfigurationException("parameter value [" + parameter + "] " + "neither 'true' nor 'false'");
        }
        if (!(value != null && value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            throw new ConfigurationException("parameter value [" + parameter + "] " + "neither 'true' nor 'false'");
        }
        boolValue = Boolean.parseBoolean(value);
        return boolValue;
    }

    public static String getDescription(String parameter) throws ConfigurationException {
        if (deploymentProps == null) {
            deploymentProps = new Properties();
            ConfigDeployUtil.loadDeployProps(deploymentProps);
        }
        String value = deploymentProps.getProperty(parameter + DESCRIPTION);
        return value;
    }

    public static String getType(String parameter) throws ConfigurationException {
        if (deploymentProps == null) {
            deploymentProps = new Properties();
            ConfigDeployUtil.loadDeployProps(deploymentProps);
        }
        String value = deploymentProps.getProperty(parameter + TYPE);
        return value;
    }

    public static String getDefault(String parameter) throws ConfigurationException {
        String value;
        if (deploymentProps == null) {
            deploymentProps = new Properties();
            ConfigDeployUtil.loadDeployProps(deploymentProps);
        }
        if ((value = deploymentProps.getProperty(parameter + DEFAULT)) == null) {
            throw new ConfigurationException("deployment parameter not found [" + parameter + "]");
        }
        return value;
    }

    public static String[] getGroupsToDiscover() throws ConfigurationException {
        String fedNameStr = System.getProperty("federation.name");
        if (fedNameStr == null) {
            fedNameStr = ConfigDeployUtil.getString("federation.name");
        }
        return fedNameStr.split(",");
    }

    public static LookupLocator[] getLocatorsToDiscover() throws ConfigurationException {
        return new LookupLocator[0];
    }

    public static ServiceInfo initServiceInfo(UUID source, String serviceName) throws SocketException, ConfigurationException {
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.source = source;
        serviceInfo.serviceName = serviceName;
        serviceInfo.inetAddresses = NicUtil.getInetAddressMap();
        String nodeNicName = ConfigDeployUtil.getString("node.serviceNetwork");
        String nodeIp = NicUtil.getIpAddress(nodeNicName, false);
        serviceInfo.nodeToken = NicUtil.getMacAddress(nodeNicName);
        if (serviceInfo.nodeToken == null) {
            serviceInfo.nodeToken = nodeIp;
        }
        serviceInfo.nodeId = null;
        serviceInfo.nodeName = ConfigDeployUtil.getString("node.name");
        serviceInfo.uNumber = ConfigDeployUtil.getInt("node.uNumber");
        serviceInfo.rack = ConfigDeployUtil.getString("node.rack");
        serviceInfo.cage = ConfigDeployUtil.getString("node.cage");
        serviceInfo.zone = ConfigDeployUtil.getString("node.zone");
        serviceInfo.site = ConfigDeployUtil.getString("node.site");
        serviceInfo.region = ConfigDeployUtil.getString("node.region");
        serviceInfo.geo = ConfigDeployUtil.getString("node.geo");
        return serviceInfo;
    }

    private static String get(String parameter) throws ConfigurationException {
        String value;
        if (deploymentProps == null) {
            deploymentProps = new Properties();
            ConfigDeployUtil.loadDeployProps(deploymentProps);
        }
        if ((value = deploymentProps.getProperty(parameter)) == null) {
            value = ConfigDeployUtil.getDefault(parameter);
        }
        return value;
    }

    private static void validateString(String parameter, String value) throws ConfigurationException {
        String[] validValues;
        String validValuesStr = (String)deploymentProps.get(parameter + STRINGVALS);
        if (validValuesStr != null && !Arrays.asList(validValues = validValuesStr.split(",")).contains(value)) {
            throw new ConfigurationException("invalid string parameter [" + parameter + "] in " + "list [" + validValuesStr + "]");
        }
    }

    private static String[] validateStringArray(String parameter, String value) throws ConfigurationException {
        String validValuesStr = (String)deploymentProps.get(parameter + STRINGVALS);
        String[] values = value.split(",");
        if (validValuesStr != null) {
            String[] validValues = validValuesStr.split(",");
            List<String> validValuesList = Arrays.asList(validValues);
            for (int i = 0; i < values.length; ++i) {
                if (validValuesList.contains(values[i])) continue;
                throw new ConfigurationException("invalid string parameter [" + parameter + "] in " + "list " + validValuesList);
            }
        }
        return values;
    }

    private static int validateInt(String parameter, String strvalue) throws ConfigurationException {
        int max;
        String maxString = (String)deploymentProps.get(parameter + MAX);
        String minString = (String)deploymentProps.get(parameter + MIN);
        int value = ConfigDeployUtil.str2int(strvalue);
        if (maxString != null && value > (max = Integer.parseInt(maxString))) {
            throw new ConfigurationException("parameter [" + parameter + "] " + "exceeds maximum [" + max + "]");
        }
        return value;
    }

    private static long validateLong(String parameter, String strvalue) throws ConfigurationException {
        long min;
        long max;
        String maxString = (String)deploymentProps.get(parameter + MAX);
        String minString = (String)deploymentProps.get(parameter + MIN);
        long value = ConfigDeployUtil.str2long(strvalue);
        if (maxString != null && value > (max = Long.parseLong(maxString))) {
            throw new ConfigurationException("parameter [" + parameter + "] " + "exceeds maximum [" + max + "]");
        }
        if (minString != null && value < (min = Long.parseLong(minString))) {
            throw new ConfigurationException("parameter [" + parameter + "] " + "is less than manimum " + "[" + min + "]");
        }
        return value;
    }

    private static String getPropertiesPath() {
        String rootPath = "/opt/bigdata";
        String appHome = System.getProperty("appHome");
        String appDotHome = System.getProperty("app.home");
        if (appHome != null) {
            rootPath = appHome;
        } else if (appDotHome != null) {
            rootPath = appDotHome + File.separator + "dist" + File.separator + "bigdata";
        }
        String relPath = "var" + File.separator + "config" + File.separator + "deploy";
        String retPath = rootPath + File.separator + relPath;
        if (!new File(retPath).exists()) {
            String tmpPath = "bigdata-jini" + File.separator + "src" + File.separator + "java" + File.separator + "com" + File.separator + "bigdata" + File.separator + "util" + File.separator + "config";
            retPath = new File(tmpPath).getAbsolutePath();
        }
        return retPath;
    }

    private static void loadDeployProps(Properties deployProps) {
        ConfigDeployUtil.loadDefaultProps(deployProps);
        ConfigDeployUtil.loadOverrideProps(deployProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultProps(Properties deployProps) {
        FileInputStream fis = null;
        try {
            String flnm = ConfigDeployUtil.getPropertiesPath() + File.separator + "default-deploy.properties";
            fis = new FileInputStream(flnm);
            deployProps.load(fis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadOverrideProps(Properties deployProps) {
        FileInputStream fis = null;
        try {
            String flnm = ConfigDeployUtil.getPropertiesPath() + File.separator + "deploy.properties";
            fis = new FileInputStream(new File(flnm));
            deployProps.load(fis);
        }
        catch (Exception ex) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    private static int str2int(String argx) {
        if (argx.trim().equals(Integer.MAX_VALUE)) {
            return Integer.MAX_VALUE;
        }
        if (argx.trim().equals(Integer.MIN_VALUE)) {
            return Integer.MIN_VALUE;
        }
        long l = ConfigDeployUtil.str2long(argx);
        if (l < Integer.MAX_VALUE && l > Integer.MIN_VALUE) {
            return (int)l;
        }
        throw new NumberFormatException("Invalid number:" + argx + "  --number out of range");
    }

    private static long str2long(String argx) {
        int minDigitNumBetwnComma = 3;
        String arg = argx.trim();
        arg = arg.replaceAll("\"", "");
        int sz = arg.length();
        if (arg.equals("Long.MAX_VALUE")) {
            return Long.MAX_VALUE;
        }
        if (arg.equals("Long.MIN_VALUE")) {
            return Long.MIN_VALUE;
        }
        int asterPos = -1;
        String arg1 = null;
        String arg2 = null;
        asterPos = arg.indexOf("*");
        if (asterPos != -1) {
            long denom;
            long numerator;
            int i;
            int dotPos = -1;
            arg1 = arg.substring(0, asterPos).trim();
            int denom1 = 1;
            dotPos = arg1.indexOf(".");
            if (dotPos != -1) {
                StringBuffer tmpBuf = new StringBuffer("1");
                boolean hitNumber = false;
                for (i = dotPos + 1; i < arg1.length() - dotPos && Character.isDigit(arg1.charAt(i)); ++i) {
                    tmpBuf.append("0");
                }
                denom1 = Integer.valueOf(tmpBuf.toString());
                arg1 = arg1.substring(0, dotPos) + arg1.substring(dotPos + 1);
            }
            arg2 = arg.substring(asterPos + 1).trim();
            int denom2 = 1;
            dotPos = arg2.indexOf(".");
            if (dotPos != -1) {
                StringBuffer tmpBuf = new StringBuffer("1");
                for (i = dotPos + 1; i <= arg2.length() - dotPos; ++i) {
                    tmpBuf.append("0");
                }
                denom2 = Integer.valueOf(tmpBuf.toString());
                arg2 = arg2.substring(0, dotPos) + arg2.substring(dotPos + 1);
            }
            if ((numerator = ConfigDeployUtil.str2long(arg1) * ConfigDeployUtil.str2long(arg2)) % (denom = (long)(denom1 * denom2)) != 0L) {
                throw new NumberFormatException(" Bad value passed in:" + (double)numerator / (double)denom + ", expecting a long");
            }
            return numerator / denom;
        }
        char unit = arg.charAt(sz - 1);
        String valScalar = arg.substring(0, sz - 1).trim();
        long factor = 0L;
        switch (Character.toUpperCase(unit)) {
            case 'G': {
                factor = 1000000000L;
                break;
            }
            case 'M': {
                factor = 1000000L;
                break;
            }
            case 'K': {
                factor = 1000L;
                break;
            }
            case 'B': {
                char unitPre = arg.charAt(sz - 2);
                if (Character.isDigit(unitPre)) {
                    factor = -1L;
                    break;
                }
                factor = Character.toUpperCase(unitPre) == 'G' ? 1000000000L : (Character.toUpperCase(unitPre) == 'M' ? 1000000L : (Character.toUpperCase(unitPre) == 'K' ? 1000L : -1L));
                valScalar = arg.substring(0, sz - 2).trim();
                break;
            }
            default: {
                if (!Character.isDigit(unit)) break;
                factor = 1L;
                valScalar = arg;
            }
        }
        if (factor == -1L) {
            throw new NumberFormatException("Invalid number:" + arg);
        }
        int comaPos = -1;
        comaPos = valScalar.indexOf(44);
        if (comaPos != -1) {
            if (valScalar.indexOf(46) != -1) {
                throw new NumberFormatException("Invalid number:" + arg + " both \",\" and decimal " + "point are not supported");
            }
            if (comaPos != 0 && comaPos != valScalar.length() - 1) {
                String[] spltByComa = valScalar.split(",");
                valScalar = "";
                for (int i = spltByComa.length - 1; i >= 0; --i) {
                    if (i > 0 && spltByComa[i].length() < minDigitNumBetwnComma) {
                        throw new NumberFormatException("Invalid number:" + arg + "  unexpected comma " + "format");
                    }
                    valScalar = spltByComa[i] + valScalar;
                }
            } else {
                throw new NumberFormatException("Invalid number:\"" + arg + "\" -unexpected comma in " + "position: " + comaPos);
            }
        }
        int decimalPos = -1;
        String valMultiplByFactor = null;
        int numZero = 0;
        try {
            decimalPos = valScalar.indexOf(46);
            if (decimalPos != -1) {
                if (decimalPos != valScalar.lastIndexOf(46)) {
                    throw new NumberFormatException("Invalid number:" + valScalar + "  --invalid decimal " + "number, bad value");
                }
                String facStr = String.valueOf(factor);
                int numZeroFactor = facStr.length() - 1;
                int numDigitsAfterDecimal = valScalar.length() - decimalPos - 1;
                int countZero = 0;
                for (int i = valScalar.length() - 1; i > decimalPos && valScalar.charAt(i) == '0'; --i) {
                    --numDigitsAfterDecimal;
                    ++countZero;
                }
                numZero = numZeroFactor - numDigitsAfterDecimal;
                if (numZero == numDigitsAfterDecimal) {
                    numZero = 0;
                }
                if (numZero < 0) {
                    throw new NumberFormatException("Invalid number:" + valScalar + "  --invalid decimal " + "number, numzero=" + numZero);
                }
                if (numZero >= 0) {
                    StringBuffer tmpStrNum = new StringBuffer(20).append(valScalar.substring(0, decimalPos)).append(valScalar.substring(decimalPos + 1, decimalPos + 1 + numDigitsAfterDecimal));
                    for (int i = 0; i < numZero; ++i) {
                        tmpStrNum.append('0');
                    }
                    valMultiplByFactor = tmpStrNum.toString();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Invalid number:" + valScalar + "  --invalid decimal number, " + "numZero=" + numZero);
        }
        long ret = -1L;
        Long ll = decimalPos != -1 ? Long.valueOf(valMultiplByFactor) : Long.valueOf(valScalar) * factor;
        ret = ll;
        if (ret >= Long.MAX_VALUE || ret <= Long.MIN_VALUE) {
            throw new NumberFormatException("Invalid number:" + arg + "  --absolute value of number " + "too big");
        }
        return ret;
    }
}

