/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public abstract class AbstractZNodeConditionWatcher
implements Watcher {
    protected static final Logger log = Logger.getLogger(AbstractZNodeConditionWatcher.class);
    protected final ZooKeeper zookeeper;
    private volatile boolean disconnected = false;
    private volatile boolean conditionsatisfied = false;
    protected final String zpath;

    protected AbstractZNodeConditionWatcher(ZooKeeper zookeeper, String zpath) {
        if (zookeeper == null) {
            throw new IllegalArgumentException();
        }
        if (zpath == null) {
            throw new IllegalArgumentException();
        }
        this.zookeeper = zookeeper;
        this.zpath = zpath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ zpath=" + this.zpath);
        sb.append(", conditionsatisfied=" + this.conditionsatisfied);
        sb.append(", disconnected=" + this.disconnected);
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }

    private final void _clearWatches() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Clearing watch: " + this));
            }
            this.clearWatch();
        }
        catch (KeeperException ex) {
            log.warn((Object)ex);
        }
        catch (InterruptedException ex) {
            log.warn((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        if (log.isInfoEnabled()) {
            log.info((Object)event.toString());
        }
        AbstractZNodeConditionWatcher abstractZNodeConditionWatcher = this;
        synchronized (abstractZNodeConditionWatcher) {
            boolean satisifed;
            switch (event.getState()) {
                case Disconnected: {
                    this.disconnected = true;
                    return;
                }
            }
            if (this.disconnected) {
                this._resumeWatch();
            }
            try {
                satisifed = this.isConditionSatisfied(event);
            }
            catch (KeeperException e) {
                log.warn((Object)this.toString(), (Throwable)e);
                return;
            }
            catch (InterruptedException e) {
                log.warn((Object)this.toString(), (Throwable)e);
                return;
            }
            if (satisifed) {
                this.success(event.getType().toString());
                return;
            }
            this._resumeWatch();
        }
    }

    protected abstract boolean isConditionSatisfied(WatchedEvent var1) throws KeeperException, InterruptedException;

    protected abstract boolean isConditionSatisfied() throws KeeperException, InterruptedException;

    protected abstract void clearWatch() throws KeeperException, InterruptedException;

    protected void _resumeWatch() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reset watch");
            }
            if (this.isConditionSatisfied()) {
                this.disconnected = false;
                this.success("already exists");
            }
            this.disconnected = false;
            if (log.isInfoEnabled()) {
                log.info((Object)"did reset watch");
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Could not reset the watch: " + this), t);
        }
    }

    protected void success(String msg) {
        this.conditionsatisfied = true;
        if (log.isInfoEnabled()) {
            log.info((Object)(msg + " : " + this));
        }
        this.notify();
        this._clearWatches();
    }

    protected boolean isCancelled() {
        return false;
    }

    public boolean awaitCondition(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitCondition(true, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitCondition(boolean testConditionOnEntry, long timeout, TimeUnit unit) throws InterruptedException {
        long begin = System.currentTimeMillis();
        long millis = unit.toMillis(timeout);
        AbstractZNodeConditionWatcher abstractZNodeConditionWatcher = this;
        synchronized (abstractZNodeConditionWatcher) {
            if (testConditionOnEntry) {
                try {
                    if (this.isConditionSatisfied()) {
                        this.success("on entry.");
                        return true;
                    }
                }
                catch (KeeperException ex) {
                    log.warn((Object)("On entry: " + (Object)((Object)ex)), (Throwable)ex);
                }
            }
            while (millis > 0L && !this.conditionsatisfied && !this.isCancelled()) {
                this.wait(millis);
                millis -= System.currentTimeMillis() - begin;
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("woke up: conditionSatisifed=" + this.conditionsatisfied + ", remaining=" + millis + "ms"));
            }
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            return millis > 0L;
        }
    }
}

