/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.io.SerializerUtil;
import com.bigdata.zookeeper.AbstractZooPrimitive;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public abstract class AbstractZooQueue<E extends Serializable>
extends AbstractZooPrimitive {
    protected static final Logger log = Logger.getLogger(AbstractZooQueue.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected final String zroot;
    private final List<ACL> acl;
    private int capacity;

    public int capacity() {
        return this.capacity;
    }

    protected abstract String getChildPrefix();

    protected abstract CreateMode getCreateMode();

    public AbstractZooQueue(ZooKeeper zookeeper, String zroot, List<ACL> acl, int capacity) throws KeeperException, InterruptedException {
        block6: {
            super(zookeeper);
            if (zroot == null) {
                throw new IllegalArgumentException();
            }
            if (acl == null) {
                throw new IllegalArgumentException();
            }
            if (capacity < 0) {
                throw new IllegalArgumentException();
            }
            this.zroot = zroot;
            this.acl = acl;
            this.capacity = capacity;
            try {
                zookeeper.create(zroot, SerializerUtil.serialize(capacity), acl, CreateMode.PERSISTENT);
                if (INFO) {
                    log.info((Object)("New queue: " + zroot));
                }
            }
            catch (KeeperException.NodeExistsException ex) {
                if (!INFO) break block6;
                log.info((Object)("Existing queue: " + zroot));
            }
        }
        this.capacity = (Integer)SerializerUtil.deserialize(zookeeper.getData(zroot, (Watcher)new CapacityWatcher(), new Stat()));
    }

    public void add(E e) throws KeeperException, InterruptedException {
        try {
            this.add(e, Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e1) {
            throw new AssertionError((Object)e1);
        }
    }

    public void add(E e, long timeout, TimeUnit unit) throws KeeperException, TimeoutException, InterruptedException {
        BlockedWatcher watcher;
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (this.capacity != Integer.MAX_VALUE && !(watcher = new BlockedWatcher(this.zookeeper, this.zroot){

            @Override
            protected boolean isDone(int queueSize) {
                return queueSize < AbstractZooQueue.this.capacity;
            }
        }).awaitCondition(timeout, unit)) {
            throw new TimeoutException();
        }
        String znode = this.zookeeper.create(this.zroot + "/" + this.getChildPrefix(), SerializerUtil.serialize(e), this.acl, this.getCreateMode());
        if (INFO) {
            log.info((Object)("zroot=" + this.zroot + ", e=" + e + ", znode=" + znode));
        }
    }

    public void awaitEmpty() throws KeeperException, InterruptedException {
        try {
            this.awaitEmpty(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e1) {
            throw new AssertionError((Object)e1);
        }
    }

    public void awaitEmpty(long timeout, TimeUnit unit) throws KeeperException, TimeoutException, InterruptedException {
        BlockedWatcher watcher = new BlockedWatcher(this.zookeeper, this.zroot){

            @Override
            protected boolean isDone(int queueSize) {
                return queueSize == 0;
            }
        };
        if (!watcher.awaitCondition(timeout, unit)) {
            throw new TimeoutException();
        }
        if (INFO) {
            log.info((Object)("zroot=" + this.zroot + " : queue is empty"));
        }
    }

    public int size() throws KeeperException, InterruptedException {
        List list = this.zookeeper.getChildren(this.zroot, false);
        int n = list.size();
        if (INFO) {
            log.info((Object)("zroot=" + this.zroot + ", size=" + n + ", children=" + list));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove() throws KeeperException, InterruptedException {
        List list;
        if (INFO) {
            log.info((Object)("zroot=" + this.zroot));
        }
        while ((list = this.zookeeper.getChildren(this.zroot, (Watcher)this)).size() == 0) {
            if (INFO) {
                log.info((Object)("zroot=" + this.zroot + " : blocked."));
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
        }
        Object[] a = list.toArray(new String[list.size()]);
        Arrays.sort(a);
        String selected = this.zroot + "/" + (String)a[0];
        Serializable e = (Serializable)SerializerUtil.deserialize(this.zookeeper.getData(selected, false, new Stat()));
        this.zookeeper.delete(selected, -1);
        if (INFO) {
            log.info((Object)("zroot=" + this.zroot + ", e=" + e));
        }
        return (E)e;
    }

    private abstract class BlockedWatcher
    implements Watcher {
        private volatile boolean cancelled = false;
        private final ZooKeeper zookeeper;
        private final String zpath;

        protected abstract boolean isDone(int var1);

        public BlockedWatcher(ZooKeeper zookeeper, String zpath) {
            if (zookeeper == null) {
                throw new IllegalArgumentException();
            }
            if (zpath == null) {
                throw new IllegalArgumentException();
            }
            this.zookeeper = zookeeper;
            this.zpath = zpath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent e) {
            if (this.cancelled) {
                if (DEBUG) {
                    log.debug((Object)"Already cancelled");
                }
                return;
            }
            BlockedWatcher blockedWatcher = this;
            synchronized (blockedWatcher) {
                this.notify();
            }
        }

        public void awaitCondition() throws InterruptedException, KeeperException {
            this.awaitCondition(Long.MAX_VALUE, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean awaitCondition(long timeout, TimeUnit unit) throws InterruptedException, KeeperException {
            long begin = System.currentTimeMillis();
            long remaining = unit.toMillis(timeout);
            try {
                BlockedWatcher blockedWatcher = this;
                synchronized (blockedWatcher) {
                    int n = this.zookeeper.getChildren(this.zpath, (Watcher)this).size();
                    if (INFO) {
                        log.info((Object)("Queue size: " + n));
                    }
                    try {
                        while (!this.isDone(n)) {
                            this.wait(remaining);
                            remaining -= System.currentTimeMillis() - begin;
                            n = this.zookeeper.getChildren(this.zpath, (Watcher)this).size();
                            if (!INFO) continue;
                            log.info((Object)("Queue size: " + n + ", remaining=" + remaining + "ms"));
                        }
                    }
                    catch (KeeperException.NoNodeException e) {
                        throw new InterruptedException();
                    }
                    catch (KeeperException e) {
                        log.error((Object)("zpath=" + this.zpath), (Throwable)e);
                    }
                    finally {
                        this.cancelled = true;
                    }
                    boolean bl = this.isDone(n);
                    return bl;
                }
            }
            finally {
                this.cancelled = true;
            }
        }
    }

    private class CapacityWatcher
    implements Watcher {
        private CapacityWatcher() {
        }

        public void process(WatchedEvent event) {
            try {
                AbstractZooQueue.this.capacity = (Integer)SerializerUtil.deserialize(AbstractZooQueue.this.zookeeper.getData(AbstractZooQueue.this.zroot, (Watcher)this, new Stat()));
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
        }
    }
}

