/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.io.SerializerUtil;
import com.bigdata.jini.start.config.ZookeeperClientConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class DumpZookeeper {
    private static final Logger log = Logger.getLogger(DumpZookeeper.class);
    final ZooKeeper z;
    static String ws = "                                                                               ";

    public DumpZookeeper(ZooKeeper z) {
        this.z = z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException, KeeperException, ConfigurationException {
        Configuration config = ConfigurationProvider.getInstance((String[])args);
        ZookeeperClientConfig zooClientConfig = new ZookeeperClientConfig(config);
        System.out.println(zooClientConfig.toString());
        boolean showData = true;
        ZooKeeper z = new ZooKeeper(zooClientConfig.servers, 2000, new Watcher(){

            public void process(WatchedEvent event) {
                log.info((Object)event);
            }
        });
        try {
            z.getData(zooClientConfig.zroot, false, null);
        }
        catch (KeeperException.NoNodeException ex) {
        }
        catch (KeeperException ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        System.out.println("Negotiated sessionTimeout=" + z.getSessionTimeout() + "ms");
        PrintWriter w = new PrintWriter(System.out);
        try {
            new DumpZookeeper(z).dump(w, true, zooClientConfig.zroot, 0);
            w.println("----");
            w.flush();
        }
        finally {
            z.close();
            w.close();
        }
    }

    public void dump(PrintWriter w, boolean showData, String zpath, int depth) throws KeeperException, InterruptedException {
        String obj;
        List<Object> children;
        byte[] data;
        Stat stat = new Stat();
        try {
            data = this.z.getData(zpath, false, stat);
        }
        catch (KeeperException.NoNodeException ex) {
            w.println("Not found: [" + zpath + "]");
            return;
        }
        String znode = zpath.substring(zpath.lastIndexOf(47) + 1);
        try {
            Object[] a = this.z.getChildren(zpath, false).toArray(new String[0]);
            Arrays.sort(a);
            children = Arrays.asList(a);
        }
        catch (KeeperException.NoNodeException ex) {
            w.println("Not found: [" + zpath + "]");
            return;
        }
        w.print(this.i(depth) + znode + (children.isEmpty() ? "" : "(" + children.size() + " children)") + (stat.getEphemeralOwner() != 0L ? " (Ephemeral" + (showData ? "" + stat.getEphemeralOwner() : "") + ")" : "") + " ");
        if (data == null) {
            obj = "(null)";
        } else if (data.length == 0) {
            obj = "(empty)";
        } else {
            try {
                Object object = SerializerUtil.deserialize(data);
                obj = showData ? (object.getClass().getComponentType() != null ? Arrays.toString((Object[])object) : object.toString()) : "{" + object.getClass().getSimpleName() + "}";
            }
            catch (Throwable throwable) {
                obj = showData ? Arrays.toString(data) : "bytes[" + data.length + "]";
            }
            w.print(obj);
        }
        w.println();
        for (String string : children) {
            this.dump(w, showData, zpath + "/" + string, depth + 1);
        }
    }

    private String i(int d) {
        return ws.substring(0, d * 2);
    }
}

