/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.zookeeper.AbstractZNodeConditionWatcher;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZNodeDeletedWatcher
extends AbstractZNodeConditionWatcher {
    public static boolean awaitDelete(ZooKeeper zookeeper, String zpath, long timeout, TimeUnit unit) throws InterruptedException {
        return new ZNodeDeletedWatcher(zookeeper, zpath).awaitCondition(timeout, unit);
    }

    protected ZNodeDeletedWatcher(ZooKeeper zookeeper, String zpath) {
        super(zookeeper, zpath);
    }

    @Override
    protected boolean isConditionSatisfied(WatchedEvent event) throws KeeperException, InterruptedException {
        return event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted);
    }

    @Override
    protected boolean isConditionSatisfied() throws KeeperException, InterruptedException {
        return this.zookeeper.exists(this.zpath, (Watcher)this) == null;
    }

    @Override
    protected void clearWatch() throws KeeperException, InterruptedException {
        this.zookeeper.exists(this.zpath, false);
    }
}

