/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.zookeeper.AbstractZooPrimitive;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooBarrier
extends AbstractZooPrimitive {
    protected static final Logger log = Logger.getLogger(ZooBarrier.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    public final String zroot;
    public final int size;

    public ZooBarrier(ZooKeeper zookeeper, String zroot, List<ACL> acl, int size) throws KeeperException, InterruptedException {
        block6: {
            super(zookeeper);
            if (zroot == null) {
                throw new IllegalArgumentException();
            }
            if (size <= 0) {
                throw new IllegalArgumentException();
            }
            this.zroot = zroot;
            this.size = size;
            try {
                ByteBuffer b = ByteBuffer.allocate(4);
                b.putInt(0, size);
                b.flip();
                zookeeper.create(zroot, b.array(), acl, CreateMode.PERSISTENT);
                if (INFO) {
                    log.info((Object)("New barrier: " + zroot));
                }
            }
            catch (KeeperException.NodeExistsException ex) {
                ByteBuffer b;
                int actualSize;
                if (INFO) {
                    log.info((Object)("Existing barrier: " + zroot));
                }
                if (size == (actualSize = (b = ByteBuffer.wrap(zookeeper.getData(zroot, false, new Stat()))).getInt(0))) break block6;
                throw new IllegalArgumentException("Expected size=" + size + ", actual=" + actualSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(String id) throws KeeperException, InterruptedException {
        List list;
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (INFO) {
            log.info((Object)("node=" + this.zroot + ", id=" + id));
        }
        this.zookeeper.create(this.zroot + "/" + id, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        while ((list = this.zookeeper.getChildren(this.zroot, (Watcher)this)).size() < this.size) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(String id) throws KeeperException, InterruptedException {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (INFO) {
            log.info((Object)("node=" + this.zroot + ", id=" + id));
        }
        this.zookeeper.delete(this.zroot + "/" + id, 0);
        List list;
        while ((list = this.zookeeper.getChildren(this.zroot, (Watcher)this)).size() != 0) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
        }
        return;
    }
}

