/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.jini.start.config.AbstractHostConstraint;
import com.bigdata.util.config.NicUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class ZooHelper {
    protected static final Logger log = Logger.getLogger(ZooHelper.class);
    private static InetAddress thisInetAddr = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ruok(InetAddress addr, int clientPort) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Querying service: hostname=" + addr + ", port=" + clientPort));
        }
        int timeout = 250;
        try (Socket socket = new Socket(addr, clientPort);){
            socket.setSoTimeout(250);
            OutputStream os = socket.getOutputStream();
            os.write("ruok".getBytes("ASCII"));
            os.flush();
            DataInputStream is = new DataInputStream(socket.getInputStream());
            byte[] b = new byte[4];
            is.readFully(b);
            if (log.isInfoEnabled()) {
                log.info((Object)new String(b, "ASCII"));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void kill(int clientPort) throws UnknownHostException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Killing service: @ port=" + clientPort));
        }
        try (Socket socket = new Socket(thisInetAddr, clientPort);){
            socket.setSoTimeout(100);
            OutputStream os = socket.getOutputStream();
            os.write("kill".getBytes("ASCII"));
            os.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)"Message sent");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stat(InetAddress addr, int clientPort) throws UnknownHostException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("hostname=" + addr + ", port=" + clientPort));
        }
        try (Socket socket = new Socket(thisInetAddr, clientPort);){
            int ch;
            socket.setSoTimeout(100);
            OutputStream os = socket.getOutputStream();
            os.write("stat".getBytes("ASCII"));
            os.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)"Message sent");
            }
            InputStream is = socket.getInputStream();
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dump(InetAddress addr, int clientPort) throws UnknownHostException, IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("hostname=" + addr + ", port=" + clientPort));
        }
        try (Socket socket = new Socket(thisInetAddr, clientPort);){
            int ch;
            socket.setSoTimeout(100);
            OutputStream os = socket.getOutputStream();
            os.write("dump".getBytes("ASCII"));
            os.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)"Message sent");
            }
            InputStream is = socket.getInputStream();
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static boolean isRunning(InetAddress addr, int clientPort) {
        try {
            ZooHelper.ruok(addr, clientPort);
            if (log.isInfoEnabled()) {
                log.info((Object)("Zookeeper running: " + addr.getCanonicalHostName() + ":" + clientPort));
            }
            return true;
        }
        catch (IOException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Zookeeper not found: " + addr.getCanonicalHostName() + ":" + clientPort));
            }
            return false;
        }
    }

    public static void destroyZNodes(ZooKeeper zookeeper, String zpath, int depth) throws KeeperException, InterruptedException {
        List children;
        try {
            children = zookeeper.getChildren(zpath, false);
        }
        catch (KeeperException.NoNodeException ex) {
            return;
        }
        for (String child : children) {
            ZooHelper.destroyZNodes(zookeeper, zpath + "/" + child, depth + 1);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("delete: " + zpath));
        }
        try {
            zookeeper.delete(zpath, -1);
        }
        catch (KeeperException.NoNodeException ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        String s;
        int pos;
        if (args.length != 2) {
            ZooHelper.usage();
        }
        if ((pos = (s = args[0]).indexOf(58)) == -1) {
            ZooHelper.usage();
        }
        String host = s.substring(0, pos);
        int clientPort = Integer.parseInt(s.substring(pos + 1));
        InetAddress addr = InetAddress.getByName(host);
        String cmd = args[1];
        if (cmd.equals("ruok")) {
            ZooHelper.ruok(addr, clientPort);
            System.out.println("imok");
        } else if (cmd.equals("dump")) {
            System.out.println(ZooHelper.dump(addr, clientPort));
        } else if (cmd.equals("stat")) {
            System.out.println(ZooHelper.stat(addr, clientPort));
        } else if (cmd.equals("kill")) {
            if (!AbstractHostConstraint.isLocalHost(host)) {
                ZooHelper.usage();
            }
            ZooHelper.kill(clientPort);
        } else {
            ZooHelper.usage();
        }
    }

    private static void usage() {
        System.err.println("usage: host:clientPort [ruok|dump|stat|kill]");
        System.err.println("       kill may only be used on the local host.");
        System.exit(1);
    }

    static {
        try {
            thisInetAddr = InetAddress.getByName(NicUtil.getIpAddress("default.nic", "default", false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

