/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.zookeeper;

import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.zookeeper.ZLockImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public final class ZooResourceLockService
implements IResourceLockService {
    protected static final Logger log = Logger.getLogger(ZooResourceLockService.class);
    private final JiniFederation<?> fed;

    public ZooResourceLockService(JiniFederation<?> fed) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        this.fed = fed;
    }

    @Override
    public IResourceLock acquireLock(String namespace) {
        try {
            return this.acquireLock(namespace, Long.MAX_VALUE);
        }
        catch (InterruptedException t) {
            throw new RuntimeException(t);
        }
        catch (TimeoutException t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public IResourceLock acquireLock(String namespace, long timeout) throws InterruptedException, TimeoutException {
        try {
            String zpath = this.fed.getZooConfig().zroot + "/" + "locks/resources" + "/" + namespace;
            final ZLockImpl zlock = ZLockImpl.getLock(this.fed.getZookeeper(), zpath, this.fed.getZooConfig().acl);
            if (log.isInfoEnabled()) {
                log.info((Object)("Acquiring zlock: " + zlock));
            }
            zlock.lock(timeout, TimeUnit.MILLISECONDS);
            if (log.isInfoEnabled()) {
                log.info((Object)("Granted zlock: " + zlock));
            }
            return new IResourceLock(){

                @Override
                public void unlock() {
                    try {
                        zlock.unlock();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            };
        }
        catch (InterruptedException t) {
            throw t;
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(namespace, t);
        }
    }
}

