/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.ValidationErrorBuilder;
import com.lexicalscope.jewel.cli.specification.OptionSpecification;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentConstructor;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentMethod;
import com.lexicalscope.jewelcli.internal.fluentreflection.$InvocationTargetRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectionMatchers;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectionRuntimeException;
import com.lexicalscope.jewelcli.internal.lamdaj.$Lambda;
import com.lexicalscope.jewelcli.internal.lamdaj.function.convert.$Converter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class ConvertTypeOfObject<T>
implements $Converter<Object, T> {
    private final $FluentClass<T> reflectedKlass;
    private final Class<?> klass;
    private final OptionSpecification specification;
    private final ValidationErrorBuilder validationErrorBuilder;

    public ConvertTypeOfObject(ValidationErrorBuilder validationErrorBuilder, OptionSpecification specification, $FluentClass<T> reflectedKlass) {
        this.validationErrorBuilder = validationErrorBuilder;
        this.specification = specification;
        this.reflectedKlass = reflectedKlass;
        this.klass = reflectedKlass.classUnderReflection();
        if (this.klass.equals(Void.TYPE)) {
            throw new AssertionError((Object)"cannot convert to void");
        }
    }

    @Override
    public T convert(Object value) {
        if (value == null) {
            return null;
        }
        if (this.isIterable() && Iterable.class.isAssignableFrom(value.getClass())) {
            return this.convertIterable(value);
        }
        if (this.reflectedKlass.assignableFromObject(value)) {
            return (T)value;
        }
        if (this.reflectedKlass.canBeUnboxed(value.getClass())) {
            return (T)value;
        }
        if (this.reflectedKlass.canBeBoxed(value.getClass())) {
            return (T)value;
        }
        $FluentClass<T> klassToCreate = this.reflectedKlass.isPrimitive() ? this.reflectedKlass.boxedType() : this.reflectedKlass;
        return this.convertValueTo(value, klassToCreate);
    }

    private <S> S convertValueTo(Object value, $FluentClass<S> klassToCreate) {
        try {
            List<$FluentMethod> valueOfMethods = klassToCreate.methods($ReflectionMatchers.hasName("valueOf").and($ReflectionMatchers.hasArguments(value.getClass())).and($ReflectionMatchers.hasType(this.klass)));
            if (!valueOfMethods.isEmpty()) {
                return (S)valueOfMethods.get(0).call(value).value();
            }
            List<$FluentConstructor<S>> singleArgumentConstructors = klassToCreate.constructors($ReflectionMatchers.hasArguments(value.getClass()));
            if (!singleArgumentConstructors.isEmpty()) {
                return singleArgumentConstructors.get(0).call(value).value();
            }
            List<$FluentConstructor<S>> typeTokenConstructors = klassToCreate.constructors($ReflectionMatchers.hasArguments(value.getClass(), Type.class));
            if (!typeTokenConstructors.isEmpty()) {
                return typeTokenConstructors.get(0).call(value, klassToCreate.type()).value();
            }
            if (klassToCreate.classUnderReflection().equals(Character.class) && value.getClass().equals(String.class)) {
                String stringValue = (String)value;
                if (stringValue.length() == 1) {
                    return (S)Character.valueOf(stringValue.charAt(0));
                }
                this.validationErrorBuilder.invalidValueForType(this.specification, String.format("value is not a character (%s)", value));
                return null;
            }
        }
        catch ($InvocationTargetRuntimeException e) {
            Throwable cause = e.getExceptionThrownByInvocationTarget();
            if (cause instanceof NumberFormatException) {
                this.validationErrorBuilder.invalidValueForType(this.specification, this.unsupportedNumberFormatMessage((NumberFormatException)cause));
            } else {
                this.validationErrorBuilder.invalidValueForType(this.specification, cause.getMessage());
            }
            return null;
        }
        catch ($ReflectionRuntimeException e) {
            this.validationErrorBuilder.unableToConstructType(this.specification, e.getMessage());
            return null;
        }
        throw new ClassCastException(String.format("cannot convert %s to %s", value.getClass(), this.klass));
    }

    private T convertIterable(Object value) {
        $FluentClass<?> desiredCollectionReflectedType = this.reflectedKlass.asType($ReflectionMatchers.reflectingOn(Iterable.class)).typeArgument(0);
        List convertedTypes = $Lambda.convert(value, new ConvertTypeOfObject(this.validationErrorBuilder, this.specification, desiredCollectionReflectedType));
        if (List.class.isAssignableFrom(this.klass) && Collection.class.isAssignableFrom(this.klass)) {
            return (T)convertedTypes;
        }
        if (Set.class.isAssignableFrom(this.klass)) {
            return (T)new LinkedHashSet(convertedTypes);
        }
        return (T)convertedTypes;
    }

    private boolean isIterable() {
        return Iterable.class.isAssignableFrom(this.klass);
    }

    static <T> ConvertTypeOfObject<T> converterTo(ValidationErrorBuilder validationErrorBuilder, OptionSpecification specification, $FluentMethod method) {
        $FluentClass<?> methodType = $ReflectionMatchers.isMutator().matches(method) ? method.args().get(0) : method.type();
        return ConvertTypeOfObject.converterTo(validationErrorBuilder, specification, methodType);
    }

    private static <T> ConvertTypeOfObject<T> converterTo(ValidationErrorBuilder validationErrorBuilder, OptionSpecification specification, $FluentClass<T> type) {
        return new ConvertTypeOfObject<T>(validationErrorBuilder, specification, type);
    }

    private String unsupportedNumberFormatMessage(NumberFormatException e1) {
        return "Unsupported number format: " + e1.getMessage();
    }
}

