/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.InvalidOptionSpecificationException;
import com.lexicalscope.jewel.cli.OptionAdapter;
import com.lexicalscope.jewel.cli.specification.OptionSpecification;
import com.lexicalscope.jewel.cli.specification.SpecificationMultiplicity;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentMethod;
import java.util.Arrays;
import java.util.List;

abstract class AbstractOptionSpecification
implements OptionSpecification,
Comparable<OptionSpecification> {
    protected final OptionAdapter annotation;
    private final List<String> defaultValue;

    public AbstractOptionSpecification(OptionAdapter annotation) {
        this.annotation = annotation;
        if (annotation.defaultToNull() && annotation.hasDefaultValue()) {
            throw new InvalidOptionSpecificationException("option cannot have null default and non-null default value: " + annotation.method());
        }
        this.defaultValue = annotation.defaultToNull() ? (annotation.isMultiValued() ? null : Arrays.asList(new String[]{null})) : (annotation.hasDefaultValue() ? Arrays.asList(annotation.defaultValue()) : null);
        if (this.hasExactCount() && this.exactly() < this.minimum() || this.exactly() > this.maximum()) {
            throw new InvalidOptionSpecificationException("option has maximum and minimum and exact count which can never be satisfied: " + annotation.method());
        }
        if (this.minimum() > this.maximum()) {
            throw new InvalidOptionSpecificationException("minimum cannot be greater than maximum: " + annotation.method());
        }
        if (this.maximum() < 0) {
            throw new InvalidOptionSpecificationException("maximum must not be less than zero: " + annotation.method());
        }
    }

    @Override
    public final List<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public final boolean hasDefaultValue() {
        return this.getDefaultValue() != null || this.annotation.defaultToNull();
    }

    @Override
    public final String getDescription() {
        return this.annotation.description();
    }

    public final Class<?> getType() {
        return this.annotation.getValueType().classUnderReflection();
    }

    @Override
    public final boolean isMultiValued() {
        return this.annotation.isMultiValued();
    }

    @Override
    public final boolean isOptional() {
        return this.getOptionalityMethod() != null || this.isBoolean() || this.hasDefaultValue();
    }

    public abstract boolean isBoolean();

    @Override
    public final String getCanonicalIdentifier() {
        return this.getMethod().property();
    }

    @Override
    public final $FluentMethod getMethod() {
        return this.annotation.method();
    }

    @Override
    public final $FluentMethod getOptionalityMethod() {
        return this.annotation.correspondingOptionalityMethod();
    }

    @Override
    public final int compareTo(OptionSpecification other) {
        return this.getCanonicalIdentifier().compareTo(other.getCanonicalIdentifier());
    }

    @Override
    public final boolean isHidden() {
        return this.annotation.isHidden();
    }

    @Override
    public boolean allowedThisManyValues(int count) {
        if (count == 0 && !this.hasValue()) {
            return true;
        }
        if (count == 1 && this.hasValue() && !this.isMultiValued()) {
            return true;
        }
        if (this.isMultiValued() && this.hasExactCount()) {
            return count == this.exactly();
        }
        if (this.isMultiValued()) {
            return this.minimum() <= count && count <= this.maximum();
        }
        return false;
    }

    public final int maximum() {
        return this.annotation.maximum();
    }

    public final int minimum() {
        return this.annotation.minimum();
    }

    public final int exactly() {
        return this.annotation.exactly();
    }

    public final boolean hasExactCount() {
        return this.annotation.exactly() >= 0;
    }

    @Override
    public <T> T compareCountToSpecification(int valueCount, SpecificationMultiplicity<T> specificationMultiplicity) {
        if (!this.hasValue() && valueCount > 0) {
            return specificationMultiplicity.expectedNoneGotSome();
        }
        if (!this.isMultiValued() && this.hasValue() && valueCount == 0) {
            return specificationMultiplicity.expectedOneGotNone();
        }
        if (!this.isMultiValued() && valueCount > 1) {
            return specificationMultiplicity.expectedOneGotSome();
        }
        if (this.isMultiValued()) {
            if (this.hasExactCount() && valueCount != this.exactly()) {
                if (valueCount < this.exactly()) {
                    return specificationMultiplicity.expectedExactGotTooFew(this.exactly(), valueCount);
                }
                return specificationMultiplicity.expectedExactGotTooMany(this.exactly(), valueCount);
            }
            if (valueCount < this.minimum()) {
                return specificationMultiplicity.expectedMinimumGotTooFew(this.minimum(), valueCount);
            }
            if (valueCount > this.maximum()) {
                return specificationMultiplicity.expectedMaximumGotTooMany(this.maximum(), valueCount);
            }
        }
        return specificationMultiplicity.allowed();
    }

    @Override
    public int maximumArgumentConsumption() {
        if (this.isMultiValued()) {
            if (this.hasExactCount()) {
                return this.exactly();
            }
            return this.maximum();
        }
        if (this.hasValue()) {
            return 1;
        }
        return 0;
    }
}

