/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.binary.BinaryQueryResultParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.Ontology;
import org.wikidata.query.rdf.common.uri.SchemaDotOrg;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.FilteredStatements;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.rdf.UpdateBuilder;

public class RdfRepository {
    private static final Logger log = LoggerFactory.getLogger(RdfRepository.class);
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(100).setMaxConnTotal(100).build();
    private final URI uri;
    private final WikibaseUris uris;
    private final String syncBody;
    private final String msyncBody;
    private final String getValues;
    private final String getRefs;
    private final String cleanUnused;
    private final String updateLeftOffTimeBody;
    private final String getRevisions;
    private final String verify;
    private int maxRetries = 5;
    private int delay = 2000;
    protected static final ResponseHandler<Integer> UPDATE_COUNT_RESPONSE = new UpdateCountResponse();
    protected static final ResponseHandler<TupleQueryResult> TUPLE_QUERY_RESPONSE = new TupleQueryResponse();
    protected static final ResponseHandler<Boolean> ASK_QUERY_RESPONSE = new AskQueryResponse();

    protected CloseableHttpClient client() {
        return this.client;
    }

    public RdfRepository(URI uri, WikibaseUris uris) {
        this.uri = uri;
        this.uris = uris;
        this.msyncBody = RdfRepository.loadBody("multiSync");
        this.syncBody = RdfRepository.loadBody("sync");
        this.updateLeftOffTimeBody = RdfRepository.loadBody("updateLeftOffTime");
        this.getValues = RdfRepository.loadBody("GetValues");
        this.getRefs = RdfRepository.loadBody("GetRefs");
        this.cleanUnused = RdfRepository.loadBody("CleanUnused");
        this.getRevisions = RdfRepository.loadBody("GetRevisions");
        this.verify = RdfRepository.loadBody("verify");
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RdfRepository setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public RdfRepository setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    private static String loadBody(String name) {
        URL url = Resources.getResource(RdfRepository.class, "RdfRepository." + name + ".sparql");
        try {
            return Resources.toString(url, Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new FatalException("Can't load " + url);
        }
    }

    private Set<String> resultToSet(TupleQueryResult result, String binding) {
        HashSet<String> values = new HashSet<String>();
        try {
            while (result.hasNext()) {
                Binding value = ((BindingSet)result.next()).getBinding(binding);
                if (value == null) continue;
                values.add(value.getValue().stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new FatalException("Can't load results: " + e, e);
        }
        return values;
    }

    private Multimap<String, String> resultToMap(TupleQueryResult result, String keyBinding, String valueBinding) {
        HashMultimap<String, String> values = HashMultimap.create();
        try {
            while (result.hasNext()) {
                BindingSet bindings = (BindingSet)result.next();
                Binding value = bindings.getBinding(valueBinding);
                Binding key = bindings.getBinding(keyBinding);
                if (value == null || key == null) continue;
                values.put(key.getValue().stringValue(), value.getValue().stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new FatalException("Can't load results: " + e, e);
        }
        return values;
    }

    public Multimap<String, String> getValues(Collection<String> entityIds) {
        UpdateBuilder b = new UpdateBuilder(this.getValues);
        b.bindUris("entityList", entityIds);
        b.bind("uris.value", this.uris.value());
        b.bind("uris.statement", this.uris.statement());
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        return this.resultToMap(this.query(b.toString()), "entity", "s");
    }

    public Multimap<String, String> getRefs(Collection<String> entityIds) {
        UpdateBuilder b = new UpdateBuilder(this.getRefs);
        b.bindUris("entityList", entityIds);
        b.bind("uris.statement", this.uris.statement());
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        return this.resultToMap(this.query(b.toString()), "entity", "s");
    }

    public String getSyncQuery(String entityId, Collection<Statement> statements, Collection<String> valueList) {
        log.debug("Generating update for {}", (Object)entityId);
        UpdateBuilder b = new UpdateBuilder(this.syncBody);
        b.bindUri("entity:id", this.uris.entity() + entityId);
        b.bindUri("schema:about", "http://schema.org/about");
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        b.bind("uris.value", this.uris.value());
        b.bind("uris.statement", this.uris.statement());
        b.bindStatements("insertStatements", statements);
        Collection<Statement> entityStatements = FilteredStatements.filtered(statements).withSubject(this.uris.entity() + entityId);
        b.bindValues("entityStatements", entityStatements);
        Collection<Statement> statementStatements = FilteredStatements.filtered(statements).withSubjectStarts(this.uris.statement());
        b.bindValues("statementStatements", statementStatements);
        HashSet<Statement> aboutStatements = new HashSet<Statement>(statements);
        aboutStatements.removeAll(entityStatements);
        aboutStatements.removeAll(statementStatements);
        aboutStatements.removeAll(FilteredStatements.filtered(statements).withSubjectStarts(this.uris.value()));
        aboutStatements.removeAll(FilteredStatements.filtered(statements).withSubjectStarts(this.uris.reference()));
        b.bindValues("aboutStatements", aboutStatements);
        if (valueList != null && !valueList.isEmpty()) {
            UpdateBuilder cleanup = new UpdateBuilder(this.cleanUnused);
            cleanup.bindUris("values", valueList);
            b.bind("cleanupQuery", cleanup.toString());
        } else {
            b.bind("cleanupQuery", "");
        }
        return b.toString();
    }

    public int syncFromChanges(Collection<Change> changes, boolean verifyResult) {
        if (changes.size() == 0) {
            return 0;
        }
        UpdateBuilder b = new UpdateBuilder(this.msyncBody);
        b.bindUri("schema:about", "http://schema.org/about");
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        b.bind("uris.value", this.uris.value());
        b.bind("uris.statement", this.uris.statement());
        HashSet<String> entityIds = new HashSet<String>(changes.size());
        ArrayList<Statement> insertStatements = new ArrayList<Statement>();
        ArrayList<Statement> entityStatements = new ArrayList<Statement>();
        HashSet<String> valueList = new HashSet<String>();
        for (Change change : changes) {
            if (change.getStatements() == null) continue;
            entityIds.add(change.entityId());
            insertStatements.addAll(change.getStatements());
            entityStatements.addAll(FilteredStatements.filtered(change.getStatements()).withSubject(this.uris.entity() + change.entityId()));
            valueList.addAll(change.getCleanupList());
        }
        if (entityIds.isEmpty()) {
            log.debug("Got no valid changes, we're done");
            return 0;
        }
        b.bindUris("entityList", entityIds, this.uris.entity());
        b.bindStatements("insertStatements", insertStatements);
        b.bindValues("entityStatements", entityStatements);
        Collection<Statement> statementStatements = FilteredStatements.filtered(insertStatements).withSubjectStarts(this.uris.statement());
        b.bindValues("statementStatements", statementStatements);
        HashSet<Statement> aboutStatements = new HashSet<Statement>(insertStatements);
        aboutStatements.removeAll(entityStatements);
        aboutStatements.removeAll(statementStatements);
        aboutStatements.removeAll(FilteredStatements.filtered(insertStatements).withSubjectStarts(this.uris.value()));
        aboutStatements.removeAll(FilteredStatements.filtered(insertStatements).withSubjectStarts(this.uris.reference()));
        b.bindValues("aboutStatements", aboutStatements);
        if (!valueList.isEmpty()) {
            UpdateBuilder cleanup = new UpdateBuilder(this.cleanUnused);
            cleanup.bindUris("values", valueList);
            b.bind("cleanupQuery", cleanup.toString());
        } else {
            b.bind("cleanupQuery", "");
        }
        long start = System.currentTimeMillis();
        int modified = this.execute("update", UPDATE_COUNT_RESPONSE, b.toString());
        log.debug("Update query took {} millis and modified {} statements", (Object)(System.currentTimeMillis() - start), (Object)modified);
        if (verifyResult) {
            try {
                this.verifyStatements(entityIds, insertStatements);
            }
            catch (QueryEvaluationException e) {
                throw new FatalException("Can't load verify results: " + e, e);
            }
        }
        return modified;
    }

    private void verifyStatements(Set<String> entityIds, List<Statement> statements) throws QueryEvaluationException {
        log.debug("Verifying the update");
        UpdateBuilder bv = new UpdateBuilder(this.verify);
        bv.bindUri("schema:about", "http://schema.org/about");
        bv.bind("uris.statement", this.uris.statement());
        bv.bindUris("entityList", entityIds, this.uris.entity());
        bv.bindValues("allStatements", statements);
        TupleQueryResult result = this.query(bv.toString());
        if (result.hasNext()) {
            log.error("Update failed, we have extra data!");
            while (result.hasNext()) {
                BindingSet bindings = (BindingSet)result.next();
                Binding s = bindings.getBinding("s");
                Binding p = bindings.getBinding("p");
                Binding o = bindings.getBinding("o");
                log.error("{}\t{}\t{}", s.getValue().stringValue(), p.getValue().stringValue(), o.getValue().stringValue());
            }
            throw new FatalException("Update failed, bad old data in the store");
        }
        log.debug("Verification OK");
    }

    public int sync(String entityId, Collection<Statement> statements, Collection<String> valueList) {
        long start = System.currentTimeMillis();
        int modified = this.execute("update", UPDATE_COUNT_RESPONSE, this.getSyncQuery(entityId, statements, valueList));
        log.debug("Updating {} took {} millis and modified {} statements", entityId, System.currentTimeMillis() - start, modified);
        return modified;
    }

    public int syncQuery(String query) {
        long start = System.currentTimeMillis();
        int modified = this.execute("update", UPDATE_COUNT_RESPONSE, query);
        log.debug("Update query took {} millis and modified {} statements", (Object)(System.currentTimeMillis() - start), (Object)modified);
        return modified;
    }

    public int sync(String entityId, Collection<Statement> statements) {
        return this.sync(entityId, statements, null);
    }

    public Set<String> hasRevisions(Collection<Change> candidates) {
        UpdateBuilder b = new UpdateBuilder(this.getRevisions);
        StringBuilder values = new StringBuilder();
        for (Change entry : candidates) {
            values.append("( <" + this.uris.entity() + entry.entityId() + "> " + entry.revision() + " )\n");
        }
        b.bind("values", values.toString());
        b.bindUri("schema:version", "http://schema.org/version");
        return this.resultToSet(this.query(b.toString()), "s");
    }

    public boolean hasRevision(String entityId, long revision) {
        StringBuilder prefixes = new StringBuilder();
        prefixes.append("PREFIX schema: <").append("http://schema.org/").append(">\n");
        prefixes.append("PREFIX entity: <").append(this.uris.entity()).append(">\n");
        return this.ask(String.format(Locale.ROOT, "%sASK {\n  entity:%s schema:version ?v .\n  FILTER (?v >= %s)\n}", prefixes, entityId, revision));
    }

    public Date fetchLeftOffTime() {
        log.info("Checking for left off time from the updater");
        StringBuilder b = SchemaDotOrg.prefix(new StringBuilder());
        b.append("SELECT * WHERE { <").append(this.uris.root()).append("> schema:dateModified ?date }");
        Date leftOffTime = this.dateFromQuery(b.toString());
        if (leftOffTime != null) {
            log.info("Found left off time from the updater");
            return leftOffTime;
        }
        log.info("Checking for left off time from the dump");
        b = Ontology.prefix(SchemaDotOrg.prefix(new StringBuilder()));
        b.append("SELECT * WHERE { ontology:Dump schema:dateModified ?date }");
        return this.dateFromQuery(b.toString());
    }

    public void updateLeftOffTime(Date leftOffTime) {
        log.debug("Setting last updated time to {}", (Object)leftOffTime);
        UpdateBuilder b = new UpdateBuilder(this.updateLeftOffTimeBody);
        b.bindUri("root", this.uris.root());
        b.bindUri("dateModified", "http://schema.org/dateModified");
        GregorianCalendar c = new GregorianCalendar(UTC, Locale.ROOT);
        c.setTime(leftOffTime);
        try {
            b.bindValue("date", DatatypeFactory.newInstance().newXMLGregorianCalendar(c));
        }
        catch (DatatypeConfigurationException e) {
            throw new FatalException("Holy cow datatype configuration exception on default datatype factory.  Seems like something really really strange.", e);
        }
        this.execute("update", UPDATE_COUNT_RESPONSE, b.toString());
    }

    public boolean ask(String sparql) {
        return this.execute("query", ASK_QUERY_RESPONSE, sparql);
    }

    public TupleQueryResult query(String sparql) {
        return this.execute("query", TUPLE_QUERY_RESPONSE, sparql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T execute(String type, ResponseHandler<T> responseHandler, String sparql) {
        HttpPost post = new HttpPost(this.uri);
        post.setHeader(new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"));
        if (responseHandler.acceptHeader() != null) {
            post.setHeader(new BasicHeader("Accept", responseHandler.acceptHeader()));
        }
        log.debug("Running SPARQL: {}", (Object)sparql);
        long startQuery = System.currentTimeMillis();
        ArrayList<BasicNameValuePair> entity = new ArrayList<BasicNameValuePair>();
        entity.add(new BasicNameValuePair(type, sparql));
        post.setEntity(new UrlEncodedFormEntity(entity, Consts.UTF_8));
        int retries = 0;
        while (true) {
            try (CloseableHttpResponse response = this.client.execute(post);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new ContainedException("Non-200 response from triple store:  " + response + " body=\n" + this.responseBodyAsString(response));
                }
                log.debug("Completed in {} ms", (Object)(System.currentTimeMillis() - startQuery));
                T t = responseHandler.parse(response.getEntity());
                return t;
            }
            catch (IOException e) {
                if (retries >= this.maxRetries) throw new FatalException("Error updating triple store", e);
                int retryIn = (int)Math.ceil((double)(this.delay * (retries + 1)) * (1.0 + Math.random() * 0.1));
                log.info("HTTP request failed: {}, retrying in {} ms", (Object)e, (Object)retryIn);
                ++retries;
                try {
                    Thread.sleep(retryIn);
                }
                catch (InterruptedException e1) {
                    throw new FatalException("Interrupted", e);
                }
            }
        }
    }

    protected String responseBodyAsString(CloseableHttpResponse response) throws IOException {
        return CharStreams.toString(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
    }

    private Date dateFromQuery(String query) {
        TupleQueryResult result = this.query(query);
        try {
            if (!result.hasNext()) {
                return null;
            }
            Binding maxLastUpdate = ((BindingSet)result.next()).getBinding("date");
            if (maxLastUpdate == null) {
                return null;
            }
            XMLGregorianCalendar xmlCalendar = ((Literal)maxLastUpdate.getValue()).calendarValue();
            GregorianCalendar calendar = xmlCalendar.toGregorianCalendar();
            return calendar.getTime();
        }
        catch (QueryEvaluationException e) {
            throw new FatalException("Error evaluating query", e);
        }
    }

    private static class AskQueryResponse
    implements ResponseHandler<Boolean> {
        private AskQueryResponse() {
        }

        @Override
        public String acceptHeader() {
            return "application/json";
        }

        @Override
        public Boolean parse(HttpEntity entity) throws IOException {
            try {
                JSONObject response = (JSONObject)new JSONParser().parse(new InputStreamReader(entity.getContent(), Charsets.UTF_8));
                return (Boolean)response.get("boolean");
            }
            catch (ParseException e) {
                throw new IOException("Error parsing response", e);
            }
        }
    }

    private static class TupleQueryResponse
    implements ResponseHandler<TupleQueryResult> {
        private TupleQueryResponse() {
        }

        @Override
        public String acceptHeader() {
            return "application/x-binary-rdf-results-table";
        }

        @Override
        public TupleQueryResult parse(HttpEntity entity) throws IOException {
            BinaryQueryResultParser p = new BinaryQueryResultParser();
            TupleQueryResultBuilder collector = new TupleQueryResultBuilder();
            p.setQueryResultHandler(collector);
            try {
                p.parseQueryResult(entity.getContent());
            }
            catch (IllegalStateException | QueryResultHandlerException | QueryResultParseException e) {
                throw new RuntimeException("Error parsing query", e);
            }
            return collector.getQueryResult();
        }
    }

    protected static class UpdateCountResponse
    implements ResponseHandler<Integer> {
        private static final Pattern ELAPSED_LINE = Pattern.compile("><p>totalElapsed=[^ ]+ elapsed=([^<]+)</p");
        private static final Pattern ELAPSED_LINE_CLAUSES = Pattern.compile("><p>totalElapsed=([^ ]+) elapsed=([^ ]+) whereClause=([^ ]+) deleteClause=([^ ]+) insertClause=([^ <]+)</p");
        private static final Pattern ELAPSED_LINE_FLUSH = Pattern.compile("><p>totalElapsed=([^ ]+) elapsed=([^ ]+) connFlush=([^ ]+) batchResolve=([^ ]+) whereClause=([^ ]+) deleteClause=([^ ]+) insertClause=([^ <]+)</p");
        private static final Pattern COMMIT_LINE = Pattern.compile("><hr><p>COMMIT: totalElapsed=([^ ]+) commitTime=[^ ]+ mutationCount=([^<]+)</p");
        private static final Pattern BULK_UPDATE_LINE = Pattern.compile("<\\?xml version=\"1.0\"\\?><data modified=\"(\\d+)\" milliseconds=\"(\\d+)\"/>");

        protected UpdateCountResponse() {
        }

        @Override
        public String acceptHeader() {
            return null;
        }

        @Override
        public Integer parse(HttpEntity entity) throws IOException {
            Integer mutationCount = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), Charsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m = ELAPSED_LINE_FLUSH.matcher(line);
                    if (m.matches()) {
                        log.debug("total = {} elapsed = {} flush = {} batch = {} where = {} delete = {} insert = {}", m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6), m.group(7));
                        continue;
                    }
                    m = ELAPSED_LINE_CLAUSES.matcher(line);
                    if (m.matches()) {
                        log.debug("total = {} elapsed = {} where = {} delete = {} insert = {}", m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
                        continue;
                    }
                    m = ELAPSED_LINE.matcher(line);
                    if (m.matches()) {
                        log.debug("elapsed = {}", (Object)m.group(1));
                        continue;
                    }
                    m = COMMIT_LINE.matcher(line);
                    if (m.matches()) {
                        log.debug("total = {} mutation count = {} ", (Object)m.group(1), (Object)m.group(2));
                        mutationCount = Integer.valueOf(m.group(2));
                        continue;
                    }
                    m = BULK_UPDATE_LINE.matcher(line);
                    if (!m.matches()) continue;
                    log.debug("bulk updated {} items in {} millis", (Object)m.group(1), (Object)m.group(2));
                    mutationCount = Integer.valueOf(m.group(1));
                }
            }
            if (mutationCount == null) {
                throw new IOException("Couldn't find the mutation count!");
            }
            return mutationCount;
        }
    }

    private static interface ResponseHandler<T> {
        public String acceptHeader();

        public T parse(HttpEntity var1) throws IOException;
    }
}

