/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.wikidata.query.rdf.tool.StreamUtils;

public final class CliUtils {
    public static Reader reader(String uri) throws IOException {
        return StreamUtils.utf8(CliUtils.inputStream(uri));
    }

    public static InputStream inputStream(String uri) throws IOException {
        if (uri.equals("-")) {
            return ForbiddenOk.systemDotIn();
        }
        InputStream stream = !uri.contains(":/") ? new BufferedInputStream(new FileInputStream(uri)) : URI.create(uri).toURL().openStream();
        if (uri.endsWith(".gz")) {
            stream = new GZIPInputStream(stream);
        }
        return stream;
    }

    public static Writer writer(String uri) throws IOException {
        return StreamUtils.utf8(CliUtils.outputStream(uri));
    }

    public static OutputStream outputStream(String out) throws IOException {
        if (out.equals("-")) {
            return ForbiddenOk.systemDotOut();
        }
        Files.createParentDirs(new File(out));
        FilterOutputStream stream = new BufferedOutputStream(new FileOutputStream(out));
        if (out.endsWith(".gz")) {
            stream = new GZIPOutputStream(stream);
        }
        return stream;
    }

    private CliUtils() {
    }

    public static class ForbiddenOk {
        public static InputStream systemDotIn() {
            return System.in;
        }

        public static PrintStream systemDotOut() {
            return System.out;
        }

        public static PrintStream systemDotErr() {
            return System.err;
        }
    }
}

