/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import java.util.Date;
import java.util.Queue;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.change.RecentChangesPoller;
import org.wikidata.query.rdf.tool.exception.RetryableException;

public class TailingChangesPoller
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TailingChangesPoller.class);
    private final RecentChangesPoller poller;
    private RecentChangesPoller.Batch lastBatch;
    private final int tailSeconds;
    private final Queue<RecentChangesPoller.Batch> queue;

    public TailingChangesPoller(RecentChangesPoller poller, Queue<RecentChangesPoller.Batch> queue, int tailSeconds) {
        this.poller = poller;
        this.tailSeconds = tailSeconds;
        this.queue = queue;
    }

    public boolean isOldEnough(Date timestamp) {
        return timestamp.before(DateUtils.addSeconds(new Date(), -this.tailSeconds));
    }

    @Override
    public void run() {
        this.setName("TailPoller");
        try {
            while (true) {
                try {
                    this.lastBatch = this.lastBatch == null ? this.poller.firstBatch() : this.poller.nextBatch(this.lastBatch);
                }
                catch (RetryableException e) {
                    log.warn("Retryable error fetching first batch.  Retrying.", e);
                }
                if (this.lastBatch.changes().size() > 0) {
                    log.info("Caught {} missing updates, adding to the queue", (Object)this.lastBatch.changes().size());
                    this.queue.add(this.lastBatch);
                }
                log.info("Tail poll up to {}", (Object)this.lastBatch.leftOffDate());
                if (this.isOldEnough(this.lastBatch.leftOffDate())) continue;
                long sleepTime = this.lastBatch.leftOffDate().getTime() - DateUtils.addSeconds(new Date(), -this.tailSeconds - 2).getTime();
                log.info("Got too close to the current stream, sleeping for {}...", (Object)sleepTime);
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

