/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.server.pathmap.PathMappings;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

@ManagedObject(value="WebSocket Upgrade Filter")
public class WebSocketUpgradeFilter
extends ContainerLifeCycle
implements Filter,
MappedWebSocketCreator,
Dumpable {
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeFilter.class);
    private final WebSocketServerFactory factory;
    private final PathMappings<WebSocketCreator> pathmap = new PathMappings();

    public static WebSocketUpgradeFilter configureContext(ServletContextHandler context) {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        WebSocketUpgradeFilter filter = new WebSocketUpgradeFilter(policy);
        FilterHolder fholder = new FilterHolder(filter);
        fholder.setName("Jetty_WebSocketUpgradeFilter");
        fholder.setDisplayName("WebSocket Upgrade Filter");
        String pathSpec = "/*";
        context.addFilter(fholder, pathSpec, EnumSet.of(DispatcherType.REQUEST));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding {} mapped to {} to {}", filter, pathSpec, context);
        }
        context.setAttribute(WebSocketUpgradeFilter.class.getName(), filter);
        return filter;
    }

    public WebSocketUpgradeFilter(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool());
    }

    public WebSocketUpgradeFilter(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.factory = new WebSocketServerFactory(policy, bufferPool);
        this.addBean((Object)this.factory, true);
    }

    @Override
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.pathmap.put(spec, creator);
    }

    @Override
    public void destroy() {
        this.factory.cleanup();
        this.pathmap.reset();
        super.destroy();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.factory == null) {
            LOG.debug("WebSocketUpgradeFilter is not operational - no WebSocketServletFactory configured", new Object[0]);
            chain.doFilter(request, response);
            return;
        }
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpreq = (HttpServletRequest)request;
            HttpServletResponse httpresp = (HttpServletResponse)response;
            String contextPath = httpreq.getContextPath();
            String target = httpreq.getRequestURI();
            if (target.startsWith(contextPath)) {
                target = target.substring(contextPath.length());
            }
            if (this.factory.isUpgradeRequest(httpreq, httpresp)) {
                LOG.debug("target = [{}]", target);
                PathMappings.MappedResource<WebSocketCreator> resource = this.pathmap.getMatch(target);
                if (resource == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WebSocket Upgrade on {} has no associated endpoint", target);
                        LOG.debug("PathMappings: {}", this.pathmap.dump());
                    }
                    chain.doFilter(request, response);
                    return;
                }
                LOG.debug("WebSocket Upgrade detected on {} for endpoint {}", target, resource);
                WebSocketCreator creator = resource.getResource();
                httpreq.setAttribute(PathSpec.class.getName(), resource.getPathSpec());
                if (this.factory.acceptWebSocket(creator, httpreq, httpresp)) {
                    return;
                }
                if (response.isCommitted()) {
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        out.append(indent).append(" +- pathmap=").append(this.pathmap.toString()).append("\n");
        this.pathmap.dump(out, indent + "   ");
    }

    public WebSocketServerFactory getFactory() {
        return this.factory;
    }

    @Override
    @ManagedAttribute(value="mappings", readonly=true)
    public PathMappings<WebSocketCreator> getMappings() {
        return this.pathmap;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        try {
            WebSocketPolicy policy = this.factory.getPolicy();
            String max = config.getInitParameter("maxIdleTime");
            if (max != null) {
                policy.setIdleTimeout(Long.parseLong(max));
            }
            if ((max = config.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("inputBufferSize")) != null) {
                policy.setInputBufferSize(Integer.parseInt(max));
            }
            this.factory.start();
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    public String toString() {
        return String.format("%s[factory=%s,pathmap=%s]", this.getClass().getSimpleName(), this.factory, this.pathmap);
    }
}

