/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.pattern;

import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.ContextAware;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.logstash.logback.pattern.NodeWriter;
import net.logstash.logback.pattern.ValueGetter;

public abstract class AbstractJsonPatternParser<Event> {
    public static final Pattern OPERATION_PATTERN = Pattern.compile("\\# (\\w+) (?: \\{ (.*) \\} )?", 4);
    private final ContextAware contextAware;
    private final JsonFactory jsonFactory;
    private final Map<String, Operation> operations = new HashMap<String, Operation>();

    public AbstractJsonPatternParser(ContextAware contextAware, JsonFactory jsonFactory) {
        this.contextAware = contextAware;
        this.jsonFactory = jsonFactory;
        this.addOperation(new AsLongOperation());
        this.addOperation(new AsDoubleOperation());
        this.addOperation(new AsJsonOperation());
    }

    protected void addOperation(Operation operation) {
        this.operations.put(operation.getName(), operation);
    }

    protected PatternLayoutBase<Event> buildLayout(String format) {
        PatternLayoutBase<Event> layout = this.createLayout();
        layout.setContext(this.contextAware.getContext());
        layout.setPattern(format);
        layout.setPostCompileProcessor(null);
        layout.start();
        return layout;
    }

    protected abstract PatternLayoutBase<Event> createLayout();

    private ValueGetter<?, Event> makeComputableValueGetter(String pattern) {
        Matcher matcher = OPERATION_PATTERN.matcher(pattern);
        if (matcher.matches()) {
            String operationName = matcher.group(1);
            String operationData = matcher.groupCount() > 1 ? matcher.group(2) : null;
            Operation operation = this.operations.get(operationName);
            if (operation != null) {
                if (operation.requiresData() && operationData == null) {
                    this.contextAware.addError("No parameter provided to operation: " + operation.getName());
                } else {
                    return operation.createValueGetter(operationData);
                }
            }
        }
        return this.makeLayoutValueGetter(pattern);
    }

    protected LayoutValueGetter<Event> makeLayoutValueGetter(String data) {
        return new LayoutValueGetter<Event>(this.buildLayout(data));
    }

    private NodeWriter<Event> parseValue(JsonNode node) {
        if (node.isTextual()) {
            ValueGetter<?, Event> getter = this.makeComputableValueGetter(node.asText());
            return new ComputableValueWriter<Event>(getter);
        }
        if (node.isArray()) {
            return this.parseArray(node);
        }
        if (node.isObject()) {
            return this.parseObject(node);
        }
        return new ConstantValueWriter(node);
    }

    private ListWriter<Event> parseArray(JsonNode node) {
        ArrayList children = new ArrayList();
        for (JsonNode item : node) {
            children.add(this.parseValue(item));
        }
        return new ListWriter(children);
    }

    private ObjectWriter<Event> parseObject(JsonNode node) {
        return new ObjectWriter<Event>(this.parseChildren(node));
    }

    private ChildrenWriter<Event> parseChildren(JsonNode node) {
        ArrayList children = new ArrayList();
        Iterator<Map.Entry<String, JsonNode>> nodeFields = node.fields();
        while (nodeFields.hasNext()) {
            Map.Entry<String, JsonNode> field = nodeFields.next();
            String key = field.getKey();
            JsonNode value = field.getValue();
            if (value.isTextual()) {
                ValueGetter<?, Event> getter = this.makeComputableValueGetter(value.asText());
                children.add(new ComputableObjectFieldWriter<Event>(key, getter));
                continue;
            }
            children.add(new DelegatingObjectFieldWriter<Event>(key, this.parseValue(value)));
        }
        return new ChildrenWriter(children);
    }

    public NodeWriter<Event> parse(String pattern) {
        JsonNode node;
        if (pattern == null) {
            this.contextAware.addError("No pattern specified");
            return null;
        }
        try {
            node = (JsonNode)this.jsonFactory.createParser(pattern).readValueAsTree();
        }
        catch (IOException e) {
            this.contextAware.addError("Failed to parse pattern [" + pattern + "]", e);
            return null;
        }
        if (node == null) {
            this.contextAware.addError("Empty JSON pattern");
            return null;
        }
        if (!node.isObject()) {
            this.contextAware.addError("Invalid pattern JSON - must be an object");
            return null;
        }
        return this.parseChildren(node);
    }

    protected static class ChildrenWriter<Event>
    implements NodeWriter<Event> {
        private final List<FieldWriter<Event>> items;

        public ChildrenWriter(List<FieldWriter<Event>> items) {
            this.items = items;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            for (FieldWriter<Event> item : this.items) {
                item.write(generator, event);
            }
        }
    }

    protected static class ObjectWriter<Event>
    implements NodeWriter<Event> {
        private final ChildrenWriter<Event> childrenWriter;

        public ObjectWriter(ChildrenWriter<Event> childrenWriter) {
            this.childrenWriter = childrenWriter;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            generator.writeStartObject();
            this.childrenWriter.write(generator, event);
            generator.writeEndObject();
        }
    }

    protected static class ComputableObjectFieldWriter<Event>
    implements FieldWriter<Event> {
        private final String name;
        private final ValueGetter<?, Event> getter;

        public ComputableObjectFieldWriter(String name, ValueGetter<?, Event> getter) {
            this.name = name;
            this.getter = getter;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            Object value = this.getter.getValue(event);
            generator.writeFieldName(this.name);
            generator.writeObject(value);
        }
    }

    protected static class DelegatingObjectFieldWriter<Event>
    implements FieldWriter<Event> {
        private final String name;
        private final NodeWriter<Event> delegate;

        public DelegatingObjectFieldWriter(String name, NodeWriter<Event> delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            generator.writeFieldName(this.name);
            this.delegate.write(generator, event);
        }
    }

    protected static class ComputableValueWriter<Event>
    implements NodeWriter<Event> {
        private final ValueGetter<?, Event> getter;

        public ComputableValueWriter(ValueGetter<?, Event> getter) {
            this.getter = getter;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            Object value = this.getter.getValue(event);
            generator.writeObject(value);
        }
    }

    protected static class ListWriter<Event>
    implements NodeWriter<Event> {
        private final List<NodeWriter<Event>> items;

        public ListWriter(List<NodeWriter<Event>> items) {
            this.items = items;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            generator.writeStartArray();
            for (NodeWriter<Event> item : this.items) {
                item.write(generator, event);
            }
            generator.writeEndArray();
        }
    }

    protected static class ConstantValueWriter<Event>
    implements NodeWriter<Event> {
        private final Object value;

        public ConstantValueWriter(Object value) {
            this.value = value;
        }

        @Override
        public void write(JsonGenerator generator, Event event) throws IOException {
            generator.writeObject(this.value);
        }
    }

    protected static interface FieldWriter<Event>
    extends NodeWriter<Event> {
    }

    protected class AsJsonValueTransformer
    extends AbstractAsObjectTransformer<JsonNode, Event> {
        public AsJsonValueTransformer(ValueGetter<String, Event> generator) {
            super(generator);
        }

        @Override
        protected JsonNode transform(String value) throws IOException {
            return (JsonNode)AbstractJsonPatternParser.this.jsonFactory.getCodec().readTree(AbstractJsonPatternParser.this.jsonFactory.createParser(value));
        }
    }

    protected static class AsDoubleValueTransformer<Event>
    extends AbstractAsNumberTransformer<Double, Event> {
        public AsDoubleValueTransformer(ValueGetter<String, Event> generator) {
            super(generator);
        }

        @Override
        protected Double transform(String value) throws NumberFormatException {
            return Double.parseDouble(value);
        }
    }

    protected static class AsLongValueTransformer<Event>
    extends AbstractAsNumberTransformer<Long, Event> {
        public AsLongValueTransformer(ValueGetter<String, Event> generator) {
            super(generator);
        }

        @Override
        protected Long transform(String value) throws NumberFormatException {
            return Long.parseLong(value);
        }
    }

    protected static abstract class AbstractAsNumberTransformer<T extends Number, Event>
    implements ValueGetter<T, Event> {
        private final ValueGetter<String, Event> generator;

        AbstractAsNumberTransformer(ValueGetter<String, Event> generator) {
            this.generator = generator;
        }

        @Override
        public T getValue(Event event) {
            String value = this.generator.getValue(event);
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return this.transform(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        protected abstract T transform(String var1) throws NumberFormatException;
    }

    protected static abstract class AbstractAsObjectTransformer<T, Event>
    implements ValueGetter<T, Event> {
        private final ValueGetter<String, Event> generator;

        AbstractAsObjectTransformer(ValueGetter<String, Event> generator) {
            this.generator = generator;
        }

        @Override
        public T getValue(Event event) {
            String value = this.generator.getValue(event);
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return this.transform(value);
            }
            catch (Exception e) {
                return null;
            }
        }

        protected abstract T transform(String var1) throws NumberFormatException, IOException;
    }

    protected static class LayoutValueGetter<Event>
    implements ValueGetter<String, Event> {
        private final PatternLayoutBase<Event> layout;

        LayoutValueGetter(PatternLayoutBase<Event> layout) {
            this.layout = layout;
        }

        @Override
        public String getValue(Event event) {
            return this.layout.doLayout(event);
        }
    }

    protected class AsJsonOperation
    extends Operation {
        public AsJsonOperation() {
            super("asJson", true);
        }

        @Override
        public ValueGetter<?, Event> createValueGetter(String data) {
            return new AsJsonValueTransformer(AbstractJsonPatternParser.this.makeLayoutValueGetter(data));
        }
    }

    protected class AsDoubleOperation
    extends Operation {
        public AsDoubleOperation() {
            super("asDouble", true);
        }

        @Override
        public ValueGetter<?, Event> createValueGetter(String data) {
            return new AsDoubleValueTransformer(AbstractJsonPatternParser.this.makeLayoutValueGetter(data));
        }
    }

    protected class AsLongOperation
    extends Operation {
        public AsLongOperation() {
            super("asLong", true);
        }

        @Override
        public ValueGetter<?, Event> createValueGetter(String data) {
            return new AsLongValueTransformer(AbstractJsonPatternParser.this.makeLayoutValueGetter(data));
        }
    }

    protected abstract class Operation {
        private final String name;
        private final boolean requiresData;

        public Operation(String name, boolean requiresData) {
            this.name = name;
            this.requiresData = requiresData;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresData() {
            return this.requiresData;
        }

        public abstract ValueGetter<?, Event> createValueGetter(String var1);
    }
}

