/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.time.DateUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.change.TailingChangesPoller;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public class RecentChangesPoller
implements Change.Source<Batch> {
    private static final Logger log = LoggerFactory.getLogger(RecentChangesPoller.class);
    private static final int MAX_SEEN_IDS = 360000;
    private final WikibaseRepository wikibase;
    private final Date firstStartTime;
    private final int batchSize;
    private final Map<Long, Boolean> seenIDs;
    private final int tailSeconds;
    private static final int BACKOFF_TIME = 10;
    private static final int BACKOFF_THRESHOLD = 2;
    private final BlockingQueue<Batch> queue = new ArrayBlockingQueue<Batch>(100);
    private TailingChangesPoller tailPoller;
    private boolean useBackoff = true;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="TODO: move to LocalDateTime")
    public RecentChangesPoller(WikibaseRepository wikibase, Date firstStartTime, int batchSize, Map<Long, Boolean> seenIDs, int tailSeconds) {
        this.wikibase = wikibase;
        this.firstStartTime = firstStartTime;
        this.batchSize = batchSize;
        this.seenIDs = seenIDs;
        this.tailSeconds = tailSeconds;
    }

    public RecentChangesPoller(WikibaseRepository wikibase, Date firstStartTime, int batchSize) {
        this(wikibase, firstStartTime, batchSize, RecentChangesPoller.createSeenMap(), -1);
    }

    public RecentChangesPoller(WikibaseRepository wikibase, Date firstStartTime, int batchSize, int tailSeconds) {
        this(wikibase, firstStartTime, batchSize, RecentChangesPoller.createSeenMap(), tailSeconds);
    }

    public void setBackoff(boolean useBackoff) {
        this.useBackoff = useBackoff;
    }

    private static Map<Long, Boolean> createSeenMap() {
        LinkedHashMap map = new LinkedHashMap(360000, 0.75f, false){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 360000;
            }
        };
        return Collections.synchronizedMap(map);
    }

    @Override
    public Batch firstBatch() throws RetryableException {
        return this.batch(this.firstStartTime, null);
    }

    @Override
    public Batch nextBatch(Batch lastBatch) throws RetryableException {
        Batch newBatch = this.batch(lastBatch.leftOffDate, lastBatch);
        if (this.tailSeconds > 0) {
            newBatch = this.checkTailPoller(newBatch);
        }
        return newBatch;
    }

    private Batch checkTailPoller(Batch lastBatch) {
        if (this.tailSeconds <= 0) {
            return lastBatch;
        }
        if (this.tailPoller == null) {
            if (lastBatch.leftOffDate().before(DateUtils.addSeconds(new Date(), -this.tailSeconds))) {
                return lastBatch;
            }
            log.info("Started trailing poller with gap of {} seconds", (Object)this.tailSeconds);
            RecentChangesPoller poller = new RecentChangesPoller(this.wikibase, DateUtils.addSeconds(new Date(), -this.tailSeconds), this.batchSize, this.seenIDs, -1);
            poller.setBackoff(false);
            this.tailPoller = new TailingChangesPoller(poller, this.queue, this.tailSeconds);
            this.tailPoller.start();
        } else {
            this.tailPoller.setPollerTs(lastBatch.leftOffDate().getTime());
            Batch queuedBatch = (Batch)this.queue.poll();
            if (queuedBatch != null) {
                log.info("Merging {} changes from trailing queue", (Object)queuedBatch.changes().size());
                return lastBatch.merge(queuedBatch);
            }
        }
        return lastBatch;
    }

    private boolean changeIsRecent(Date nextStartTime) {
        return nextStartTime.after(DateUtils.addMinutes(new Date(), -2));
    }

    private JSONObject fetchRecentChanges(Date lastNextStartTime, Batch lastBatch) throws RetryableException {
        if (this.useBackoff && this.changeIsRecent(lastNextStartTime)) {
            return this.wikibase.fetchRecentChangesByTime(DateUtils.addSeconds(lastNextStartTime, -10), this.batchSize);
        }
        return this.wikibase.fetchRecentChanges(lastNextStartTime, lastBatch != null ? lastBatch.getLastContinue() : null, this.batchSize);
    }

    private Batch batch(Date lastNextStartTime, Batch lastBatch) throws RetryableException {
        try {
            boolean backoffOverflow;
            JSONObject recentChanges = this.fetchRecentChanges(lastNextStartTime, lastBatch);
            LinkedHashMap<String, Change> changesByTitle = new LinkedHashMap<String, Change>();
            JSONObject nextContinue = (JSONObject)recentChanges.get("continue");
            long nextStartTime = lastNextStartTime.getTime();
            JSONArray result = (JSONArray)((JSONObject)recentChanges.get("query")).get("recentchanges");
            DateFormat df = WikibaseRepository.inputDateFormat();
            for (Object rco : result) {
                JSONObject rc = (JSONObject)rco;
                long namespace = (Long)rc.get("ns");
                long rcid = (Long)rc.get("rcid");
                Date timestamp = df.parse(rc.get("timestamp").toString());
                nextStartTime = Math.max(nextStartTime, timestamp.getTime());
                if (!this.wikibase.isEntityNamespace(namespace)) {
                    log.info("Skipping change in irrelevant namespace:  {}", (Object)rc);
                    continue;
                }
                if (!this.wikibase.isValidEntity(rc.get("title").toString())) {
                    log.info("Skipping change with bogus title:  {}", (Object)rc.get("title").toString());
                    continue;
                }
                if (this.seenIDs.containsKey(rcid)) {
                    log.debug("Skipping repeated change with rcid {}", (Object)rcid);
                    continue;
                }
                this.seenIDs.put(rcid, true);
                Change change = rc.get("type").toString().equals("log") && (Long)rc.get("revid") == 0L ? new Change(rc.get("title").toString(), -1L, timestamp, rcid) : new Change(rc.get("title").toString(), (Long)rc.get("revid"), timestamp, (Long)rc.get("rcid"));
                Change dupe = changesByTitle.put(change.entityId(), change);
                if (dupe == null || dupe.revision() <= change.revision() && dupe.revision() >= 0L) continue;
                changesByTitle.remove(change.entityId());
                changesByTitle.put(change.entityId(), dupe);
            }
            ImmutableList changes = ImmutableList.copyOf(changesByTitle.values());
            boolean bl = backoffOverflow = this.useBackoff && changes.size() == 0 && result.size() >= this.batchSize;
            if (backoffOverflow) {
                log.info("Backoff overflow, advancing next time to {}", (Object)WikibaseRepository.inputDateFormat().format(new Date(nextStartTime += 1000L)));
            }
            if (changes.size() != 0) {
                log.info("Got {} changes, from {} to {}", changes.size(), ((Change)changes.get(0)).toString(), ((Change)changes.get(changes.size() - 1)).toString());
            } else {
                log.info("Got no real changes");
            }
            String upTo = WikibaseRepository.inputDateFormat().format(new Date(nextStartTime - 1000L));
            long advanced = nextStartTime - lastNextStartTime.getTime();
            Batch batch = new Batch(changes, advanced, upTo, new Date(nextStartTime), nextContinue);
            if (backoffOverflow && nextContinue != null) {
                log.info("Got only old changes, next is: {}", (Object)nextContinue.toJSONString());
                batch.hasChanges(true);
            }
            return batch;
        }
        catch (ParseException e) {
            throw new RetryableException("Parse error from api", e);
        }
    }

    public static final class Batch
    extends Change.Batch.AbstractDefaultImplementation {
        private final Date leftOffDate;
        private final JSONObject lastContinue;
        private boolean hasChanges;

        private Batch(ImmutableList<Change> changes, long advanced, String leftOff, Date nextStartTime, JSONObject lastContinue) {
            super(changes, advanced, leftOff);
            this.leftOffDate = nextStartTime;
            this.lastContinue = lastContinue;
        }

        public void hasChanges(boolean changes) {
            this.hasChanges = changes;
        }

        @Override
        public boolean hasAnyChanges() {
            if (this.hasChanges) {
                return true;
            }
            return super.hasAnyChanges();
        }

        @Override
        public String advancedUnits() {
            return "milliseconds";
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="TODO: move to LocalDateTime")
        public Date leftOffDate() {
            return this.leftOffDate;
        }

        @Override
        public String leftOffHuman() {
            if (this.lastContinue != null) {
                return WikibaseRepository.inputDateFormat().format(this.leftOffDate) + " (next: " + this.lastContinue.get("rccontinue") + ")";
            }
            return WikibaseRepository.inputDateFormat().format(this.leftOffDate);
        }

        @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"}, justification="Type seems semantically correct")
        public Batch merge(Batch another) {
            ImmutableCollection newChanges = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(another.changes())).addAll(this.changes())).build();
            return new Batch((ImmutableList<Change>)newChanges, this.advanced(), this.leftOffDate.toString(), this.leftOffDate, this.lastContinue);
        }

        public JSONObject getLastContinue() {
            return this.lastContinue;
        }
    }
}

