/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;

public abstract class IteratingCallback
implements Callback {
    private final AtomicReference<State> _state;

    protected IteratingCallback() {
        this._state = new AtomicReference<State>(State.INACTIVE);
    }

    protected IteratingCallback(boolean needReset) {
        this._state = new AtomicReference<State>(needReset ? State.SUCCEEDED : State.INACTIVE);
    }

    protected abstract Action process() throws Exception;

    @Deprecated
    protected void completed() {
    }

    protected void onCompleteSuccess() {
        this.completed();
    }

    protected void onCompleteFailure(Throwable x) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void iterate() {
        try {
            block6: while (true) {
                switch (this._state.get()) {
                    case INACTIVE: {
                        if (!this.processIterations()) continue block6;
                        return;
                    }
                    case ITERATING: {
                        if (this._state.compareAndSet(State.ITERATING, State.ITERATE_AGAIN)) return;
                        continue block6;
                    }
                }
                break;
            }
            return;
        }
        catch (Throwable x) {
            this.failed(x);
            return;
        }
    }

    private boolean processIterations() throws Exception {
        block9: while (this._state.compareAndSet(State.INACTIVE, State.ITERATING)) {
            Action action = this.process();
            switch (action) {
                case IDLE: {
                    if (this._state.compareAndSet(State.ITERATING, State.INACTIVE)) {
                        return true;
                    }
                    if (!this._state.compareAndSet(State.ITERATE_AGAIN, State.INACTIVE)) continue block9;
                    continue block9;
                }
                case SCHEDULED: {
                    if (!this._state.compareAndSet(State.ITERATING, State.ACTIVE) && !this._state.compareAndSet(State.ITERATE_AGAIN, State.ACTIVE)) continue block9;
                    return true;
                }
                case SUCCEEDED: {
                    State current;
                    do {
                        current = this._state.get();
                        switch (current) {
                            case SUCCEEDED: 
                            case FAILED: {
                                return true;
                            }
                            case CLOSED: {
                                throw new IllegalStateException();
                            }
                        }
                    } while (!this._state.compareAndSet(current, State.SUCCEEDED));
                    this.onCompleteSuccess();
                    return true;
                }
            }
            throw new IllegalStateException(this.toString());
        }
        return false;
    }

    @Override
    public void succeeded() {
        block6: while (true) {
            State current = this._state.get();
            switch (current) {
                case ITERATING: 
                case ITERATE_AGAIN: {
                    if (!this._state.compareAndSet(current, State.INACTIVE)) continue block6;
                    return;
                }
                case ACTIVE: {
                    if (this._state.compareAndSet(current, State.INACTIVE)) {
                        this.iterate();
                    }
                    return;
                }
                case INACTIVE: {
                    this.iterate();
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this.toString());
    }

    @Override
    public void failed(Throwable x) {
        State current;
        do {
            current = this._state.get();
            switch (current) {
                case INACTIVE: 
                case SUCCEEDED: 
                case FAILED: 
                case CLOSED: {
                    return;
                }
            }
        } while (!this._state.compareAndSet(current, State.FAILED));
        this.onCompleteFailure(x);
    }

    /*
     * Unable to fully structure code
     */
    public void close() {
        do lbl-1000:
        // 3 sources

        {
            current = this._state.get();
            switch (1.$SwitchMap$org$eclipse$jetty$util$IteratingCallback$State[current.ordinal()]) {
                case 1: 
                case 3: 
                case 4: {
                    if (!this._state.compareAndSet(current, State.CLOSED)) ** GOTO lbl-1000
                    return;
                }
            }
        } while (!this._state.compareAndSet(current, State.CLOSED));
        this.onCompleteFailure(new IllegalStateException("Closed with pending callback " + this));
    }

    boolean isIdle() {
        return this._state.get() == State.INACTIVE;
    }

    public boolean isClosed() {
        return this._state.get() == State.CLOSED;
    }

    public boolean isFailed() {
        return this._state.get() == State.FAILED;
    }

    public boolean isSucceeded() {
        return this._state.get() == State.SUCCEEDED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reset() {
        block5: while (true) {
            switch (this._state.get()) {
                case INACTIVE: {
                    return true;
                }
                case SUCCEEDED: {
                    if (!this._state.compareAndSet(State.SUCCEEDED, State.INACTIVE)) continue block5;
                    return true;
                }
                case FAILED: {
                    if (this._state.compareAndSet(State.FAILED, State.INACTIVE)) return true;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._state);
    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED;

    }

    private static enum State {
        INACTIVE,
        ACTIVE,
        ITERATING,
        ITERATE_AGAIN,
        SUCCEEDED,
        FAILED,
        CLOSED;

    }
}

