/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.Updater;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.change.IdListChangeSource;
import org.wikidata.query.rdf.tool.change.IdRangeChangeSource;
import org.wikidata.query.rdf.tool.change.RecentChangesPoller;
import org.wikidata.query.rdf.tool.options.OptionsUtils;
import org.wikidata.query.rdf.tool.options.UpdateOptions;
import org.wikidata.query.rdf.tool.rdf.Munger;
import org.wikidata.query.rdf.tool.rdf.RdfRepository;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public final class Update {
    private static final Logger log = LoggerFactory.getLogger(Update.class);
    private static final String MAX_DAYS_BACK_NAME = "wikibaseMaxDaysBack";

    private Update() {
    }

    public static void main(String[] args) throws Exception {
        Updater<? extends Change.Batch> updater;
        WikibaseRepository wikibaseRepository;
        RdfRepository rdfRepository = null;
        try {
            UpdateOptions options = OptionsUtils.handleOptions(UpdateOptions.class, args);
            wikibaseRepository = Update.buildWikibaseRepository(options);
            URI sparqlUri = Update.sparqlUri(options);
            WikibaseUris uris = new WikibaseUris(options.wikibaseHost());
            rdfRepository = new RdfRepository(sparqlUri, uris);
            Change.Source<? extends Change.Batch> changeSource = Update.buildChangeSource(options, rdfRepository, wikibaseRepository);
            updater = Update.createUpdater(options, wikibaseRepository, uris, rdfRepository, changeSource);
        }
        catch (Exception e) {
            log.error("Error during initialization.", e);
            if (rdfRepository != null) {
                rdfRepository.close();
            }
            throw e;
        }
        try (WikibaseRepository w = wikibaseRepository;
             RdfRepository r = rdfRepository;
             Updater<? extends Change.Batch> u = updater;){
            updater.run();
        }
        catch (Exception e) {
            log.error("Error during updater run.", e);
            throw e;
        }
    }

    private static Updater<? extends Change.Batch> createUpdater(UpdateOptions options, WikibaseRepository wikibaseRepository, WikibaseUris uris, RdfRepository rdfRepository, Change.Source<? extends Change.Batch> changeSource) {
        int threads = options.threadCount();
        ThreadFactoryBuilder threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("update %s");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory.build());
        Munger munger = OptionsUtils.mungerFromOptions(options);
        return new Updater<Change.Batch>(changeSource, wikibaseRepository, rdfRepository, munger, executor, options.pollDelay(), uris, options.verify());
    }

    private static URI sparqlUri(UpdateOptions options) {
        URI sparqlUri;
        try {
            sparqlUri = new URI(options.sparqlUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url:  " + options.sparqlUrl(), e);
        }
        return sparqlUri;
    }

    @Nonnull
    private static Change.Source<? extends Change.Batch> buildChangeSource(UpdateOptions options, RdfRepository rdfRepository, WikibaseRepository wikibaseRepository) {
        if (options.idrange() != null) {
            return Update.buildIdRangeChangeSource(options.idrange(), options.batchSize());
        }
        if (options.ids() != null) {
            return Update.buildIdListChangeSource(options.ids(), options.batchSize());
        }
        return Update.buildRecentChangePollerChangeSource(rdfRepository, wikibaseRepository, options.start(), options.init(), options.batchSize(), options.tailPollerOffset());
    }

    @Nonnull
    private static Change.Source<? extends Change.Batch> buildRecentChangePollerChangeSource(RdfRepository rdfRepository, WikibaseRepository wikibaseRepository, String start, boolean init, int batchSize, int tailPollerOffset) {
        long startTime;
        if (start != null) {
            startTime = Update.parseDate(start);
            if (init) {
                rdfRepository.updateLeftOffTime(new Date(startTime));
            }
        } else {
            log.info("Checking where we left off");
            Date leftOff = rdfRepository.fetchLeftOffTime();
            Integer maxDays = Integer.valueOf(System.getProperty(MAX_DAYS_BACK_NAME, "30"));
            long minStartTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(maxDays.intValue());
            if (leftOff == null) {
                startTime = minStartTime;
                log.info("Defaulting start time to {} days ago:  {}", (Object)maxDays, (Object)WikibaseRepository.inputDateFormat().format(new Date(startTime)));
            } else {
                if (leftOff.getTime() < minStartTime) {
                    throw new IllegalStateException("RDF store reports the last update time is before the minimum safe poll time.  You will have to reload from scratch or you might have missing data.");
                }
                startTime = leftOff.getTime();
                log.info("Found start time in the RDF store: {}", (Object)WikibaseRepository.inputDateFormat().format(leftOff));
            }
        }
        return new RecentChangesPoller(wikibaseRepository, new Date(startTime), batchSize, tailPollerOffset);
    }

    private static long parseDate(String dateStr) {
        try {
            return WikibaseRepository.outputDateFormat().parse(dateStr).getTime();
        }
        catch (ParseException e) {
            try {
                return WikibaseRepository.inputDateFormat().parse(dateStr).getTime();
            }
            catch (ParseException e2) {
                throw new IllegalArgumentException("Invalid date: " + dateStr, e2);
            }
        }
    }

    private static Change.Source<? extends Change.Batch> buildIdListChangeSource(List<String> ids, int batchSize) {
        ArrayList<String> parsedIds = new ArrayList<String>();
        for (String idOpt : ids) {
            if (idOpt.contains(",")) {
                parsedIds.addAll(Arrays.asList(idOpt.split(",")));
                continue;
            }
            parsedIds.add(idOpt);
        }
        return new IdListChangeSource(parsedIds.toArray(new String[parsedIds.size()]), batchSize);
    }

    private static Change.Source<? extends Change.Batch> buildIdRangeChangeSource(String idrange, int batchSize) {
        long end;
        long start;
        String[] ids = idrange.split("-");
        switch (ids.length) {
            case 1: {
                if (!Character.isDigit(ids[0].charAt(0))) {
                    return new IdListChangeSource(ids, batchSize);
                }
                end = start = Long.parseLong(ids[0]);
                break;
            }
            case 2: {
                start = Long.parseLong(ids[0]);
                end = Long.parseLong(ids[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format for --idrange.  Need <start>-<stop>.");
            }
        }
        return IdRangeChangeSource.forItems(start, end, batchSize);
    }

    private static WikibaseRepository buildWikibaseRepository(UpdateOptions options) {
        if (options.entityNamespaces() == null) {
            return new WikibaseRepository(options.wikibaseScheme(), options.wikibaseHost());
        }
        String[] strEntityNamespaces = options.entityNamespaces().split(",");
        long[] longEntityNamespaces = new long[strEntityNamespaces.length];
        try {
            for (int i = 0; i < strEntityNamespaces.length; ++i) {
                longEntityNamespaces[i] = Long.parseLong(strEntityNamespaces[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value for --entityNamespaces. Namespace index should be an integer.", e);
        }
        return new WikibaseRepository(options.wikibaseScheme(), options.wikibaseHost(), 0, longEntityNamespaces);
    }
}

