/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.HttpServer;

class CleanupThread
extends Thread {
    private HttpServer server;
    private ThreadGroup threadGroup;
    private boolean active = true;

    CleanupThread(HttpServer pServer, ThreadGroup pThreadGroup) {
        super("Jolokia Agent Cleanup Thread");
        this.server = pServer;
        this.threadGroup = pThreadGroup;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            boolean retry = true;
            while (retry && this.active) {
                Thread[] threads = this.enumerateThreads();
                retry = this.joinThreads(threads);
            }
        }
        finally {
            this.server.stop(0);
        }
    }

    public void stopServer() {
        this.active = false;
        this.interrupt();
    }

    private Thread[] enumerateThreads() {
        boolean fits = false;
        int inc = 50;
        Thread[] threads = null;
        int nrThreads = 0;
        while (!fits) {
            try {
                threads = new Thread[Thread.activeCount() + inc];
                nrThreads = Thread.enumerate(threads);
                fits = true;
            }
            catch (ArrayIndexOutOfBoundsException exp) {
                inc += 50;
            }
        }
        Thread[] ret = new Thread[nrThreads];
        System.arraycopy(threads, 0, ret, 0, nrThreads);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinThreads(Thread[] pThreads) {
        for (int i = 0; i < pThreads.length; ++i) {
            Thread t = pThreads[i];
            if (t.isDaemon() || t.getThreadGroup() == null || t.getThreadGroup().equals(this.threadGroup) || this.checkExcludedNames(t.getName())) continue;
            try {
                t.join();
            }
            catch (Exception exception) {}
            finally {
                return true;
            }
        }
        return false;
    }

    private boolean checkExcludedNames(String pName) {
        for (String s : new String[]{"WrapperListener_stop_runner", "DestroyJavaVM"}) {
            if (!pName.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

