/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.wikidata.query.rdf.tool.Utils;
import org.wikidata.query.rdf.tool.change.KafkaOffsetsRepository;
import org.wikidata.query.rdf.tool.rdf.UpdateBuilder;
import org.wikidata.query.rdf.tool.rdf.client.RdfClient;

public class RdfKafkaOffsetsRepository
implements KafkaOffsetsRepository {
    private static final String GET_OFFSETS = Utils.loadBody("GetKafkaOffsets", RdfKafkaOffsetsRepository.class);
    private static final String UPDATE_OFFSETS = Utils.loadBody("updateOffsets", RdfKafkaOffsetsRepository.class);
    private final URI root;
    private final RdfClient rdfClient;

    public RdfKafkaOffsetsRepository(URI root, RdfClient rdfClient) {
        this.root = root;
        this.rdfClient = rdfClient;
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> load(Instant firstStartTime) {
        UpdateBuilder ub = new UpdateBuilder(GET_OFFSETS);
        ub.bindUri("root", this.root);
        ImmutableSetMultimap<String, String> result = this.rdfClient.selectToMap(ub.toString(), "topic", "offset");
        return result.entries().stream().collect(ImmutableMap.toImmutableMap(e -> {
            String[] parts = ((String)e.getKey()).split(":", 2);
            return new TopicPartition(parts[0], Integer.parseInt(parts[1]));
        }, e -> new OffsetAndTimestamp(Integer.parseInt((String)e.getValue()), firstStartTime.toEpochMilli())));
    }

    @Override
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="we want to be platform independent here.")
    public void store(Map<TopicPartition, Long> partitionsAndOffsets) {
        UpdateBuilder ub = new UpdateBuilder(UPDATE_OFFSETS);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TopicPartition, Long> partitionAndOffset : partitionsAndOffsets.entrySet()) {
            TopicPartition tp = partitionAndOffset.getKey();
            Long offset = partitionAndOffset.getValue();
            sb.append(String.format(Locale.ROOT, "<%s> wikibase:kafka ( \"%s:%d\" %d ) .\n", this.root, tp.topic(), tp.partition(), offset));
        }
        ub.bindUri("root", this.root);
        ub.bind("data", sb.toString());
        this.rdfClient.update(ub.toString());
    }
}

