/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.options;

import com.google.common.collect.ImmutableSet;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.options.OptionsUtils;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public interface UpdateOptions
extends OptionsUtils.BasicOptions,
OptionsUtils.MungerOptions,
OptionsUtils.WikibaseOptions {
    @Option(shortName={"s"}, defaultToNull=true, description="Start time in 2015-02-11T17:11:08Z or 20150211170100 format.")
    public String start();

    @Option(shortName={"S"}, defaultValue={"https"}, description="Wikidata url scheme")
    public String wikibaseScheme();

    @Option(shortName={"W"}, defaultToNull=true, description="Wikibase instance base URL")
    public String wikibaseUrl();

    @Option(shortName={"I"}, longName={"init"}, description="Initialize last update time to start time")
    public boolean init();

    @Option(shortName={"u"}, description="URL to post updates and queries.")
    public String sparqlUrl();

    @Option(shortName={"d"}, defaultValue={"10"}, description="Poll delay when no updates found")
    public int pollDelay();

    @Option(shortName={"t"}, defaultValue={"10"}, description="Thread count")
    public int threadCount();

    @Option(shortName={"b"}, defaultValue={"100"}, description="Number of recent changes fetched at a time.")
    public int batchSize();

    @Option(shortName={"V"}, longName={"verify"}, description="Verify updates (may have performance impact)")
    public boolean verify();

    @Option(shortName={"T"}, defaultValue={"0"}, longName={"tailPoller"}, description="Use secondary poller with given gap (seconds) to catch up missed updates. Applies only to RecentChanges poller.")
    public int tailPollerOffset();

    @Option(shortName={"K"}, defaultToNull=true, longName={"kafka"}, description="If set, use Kafka polling with the argument as the broker server")
    public String kafkaBroker();

    @Option(shortName={"C"}, defaultToNull=true, longName={"consumer"}, description="Set consumer ID for Kafka poller")
    public String consumerId();

    @Option(shortName={"c"}, defaultToNull=true, longName={"clusters"}, description="Kafka cluster prefixes (e.g. eqiad, codfw), comma or space separated")
    public List<String> clusters();

    @Option(defaultToNull=true, description="If specified must be <id> or list of <id>, comma or space separated.")
    public List<String> ids();

    @Option(defaultToNull=true, description="If specified must be <start>-<end>. Ids are iterated instead of recent changes. Start and end are inclusive.")
    public String idrange();

    @Option(defaultToNull=true, description="If specified must be numerical indexes of Item and Property namespaces that defined in Wikibase repository, comma separated.")
    public String entityNamespaces();

    @Option(description="Run Updater in test mode - only report updates but do not record")
    public boolean testMode();

    @Option(description="Load Wikibase constraints data")
    public boolean constraints();

    @Option(description="Reset Kafka offsets")
    public boolean resetKafka();

    @Option(description="Set RDF dumping in this directory", defaultToNull=true)
    public String dumpDir();

    @Option(longName={"metricDomain"}, defaultValue={"wdqs-updater"}, description="JMX metrics domain")
    public String metricDomain();

    public static Set<Long> longEntityNamespaces(UpdateOptions updateOptions) {
        if (updateOptions.entityNamespaces() == null) {
            return WikibaseRepository.Uris.DEFAULT_ENTITY_NAMESPACES;
        }
        return OptionsUtils.splitByComma(Arrays.asList(updateOptions.entityNamespaces())).stream().map(Long::parseLong).collect(ImmutableSet.toImmutableSet());
    }

    public static URI getWikibaseUrl(UpdateOptions updateOptions) {
        if (updateOptions.wikibaseUrl() != null) {
            try {
                return new URI(updateOptions.wikibaseUrl());
            }
            catch (URISyntaxException e) {
                throw new FatalException("Unable to build Wikibase url", e);
            }
        }
        URIBuilder baseUrl = new URIBuilder();
        baseUrl.setHost(updateOptions.wikibaseHost());
        baseUrl.setScheme(updateOptions.wikibaseScheme());
        try {
            return baseUrl.build();
        }
        catch (URISyntaxException e) {
            throw new FatalException("Unable to build Wikibase url", e);
        }
    }

    public static URI sparqlUri(UpdateOptions updateOptions) {
        URI sparqlUri;
        try {
            sparqlUri = new URI(updateOptions.sparqlUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url:  " + updateOptions.sparqlUrl(), e);
        }
        return sparqlUri;
    }

    @Nullable
    public static Instant startInstant(UpdateOptions updateOptions) {
        if (updateOptions.start() == null) {
            return null;
        }
        return UpdateOptions.parseDate(updateOptions.start());
    }

    @Nullable
    public static String[] parsedIds(UpdateOptions updateOptions) {
        List<String> split = OptionsUtils.splitByComma(updateOptions.ids());
        if (split == null) {
            return null;
        }
        return split.toArray(new String[split.size()]);
    }

    public static boolean ignoreStoredOffsets(UpdateOptions updateOptions) {
        return updateOptions.start() != null || updateOptions.resetKafka();
    }

    public static WikibaseRepository.Uris uris(UpdateOptions updateOptions) {
        return new WikibaseRepository.Uris(UpdateOptions.getWikibaseUrl(updateOptions), UpdateOptions.longEntityNamespaces(updateOptions));
    }

    public static List<String> clusterNames(UpdateOptions updateOptions) {
        return OptionsUtils.splitByComma(updateOptions.clusters());
    }

    @Nullable
    public static Path dumpDirPath(UpdateOptions updateOptions) {
        String dumpDir = updateOptions.dumpDir();
        if (dumpDir == null) {
            return null;
        }
        Path dumpDirPath = Paths.get(dumpDir, new String[0]);
        File dumpDirFile = dumpDirPath.toFile();
        if (!(dumpDirFile.exists() && dumpDirFile.isDirectory() && Files.isWritable(dumpDirPath))) {
            throw new IllegalArgumentException("Bad dump directory: " + dumpDir);
        }
        return dumpDirPath;
    }

    public static Instant parseDate(String dateStr) {
        try {
            return WikibaseRepository.OUTPUT_DATE_FORMATTER.parse((CharSequence)dateStr, Instant::from);
        }
        catch (DateTimeParseException e) {
            try {
                return WikibaseRepository.INPUT_DATE_FORMATTER.parse((CharSequence)dateStr, Instant::from);
            }
            catch (DateTimeParseException e2) {
                throw new IllegalArgumentException("Invalid date: " + dateStr, e2);
            }
        }
    }
}

