/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.api.ContentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.rdf.client.ResponseHandler;

class UpdateCountResponse
implements ResponseHandler<Integer> {
    private static final Logger log = LoggerFactory.getLogger(UpdateCountResponse.class);
    private static final Pattern ELAPSED_LINE = Pattern.compile("><p>totalElapsed=[^ ]+ elapsed=([^<]+)</p");
    private static final Pattern ELAPSED_LINE_CLAUSES = Pattern.compile("><p>totalElapsed=([^ ]+) elapsed=([^ ]+) whereClause=([^ ]+) deleteClause=([^ ]+) insertClause=([^ <]+)</p");
    private static final Pattern ELAPSED_LINE_FLUSH = Pattern.compile("><p>totalElapsed=([^ ]+) elapsed=([^ ]+) connFlush=([^ ]+) batchResolve=([^ ]+) whereClause=([^ ]+) deleteClause=([^ ]+) insertClause=([^ <]+)</p");
    private static final Pattern COMMIT_LINE = Pattern.compile("><hr><p>COMMIT: totalElapsed=([^ ]+) commitTime=[^ ]+ mutationCount=([^<]+)</p");
    private static final Pattern BULK_UPDATE_LINE = Pattern.compile("<\\?xml version=\"1.0\"\\?><data modified=\"(\\d+)\" milliseconds=\"(\\d+)\"/>");

    UpdateCountResponse() {
    }

    @Override
    public String acceptHeader() {
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"}, justification="more readable with 2 calls")
    public Integer parse(ContentResponse entity) throws IOException {
        Integer mutationCount = null;
        String content = entity.getContentAsString();
        for (String line : content.split("\\r?\\n")) {
            Matcher m = ELAPSED_LINE_FLUSH.matcher(line);
            if (m.matches()) {
                log.debug("total = {} elapsed = {} flush = {} batch = {} where = {} delete = {} insert = {}", m.group(1), m.group(2), m.group(3), m.group(4), m.group(5), m.group(6), m.group(7));
                continue;
            }
            m = ELAPSED_LINE_CLAUSES.matcher(line);
            if (m.matches()) {
                log.debug("total = {} elapsed = {} where = {} delete = {} insert = {}", m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
                continue;
            }
            m = ELAPSED_LINE.matcher(line);
            if (m.matches()) {
                log.debug("elapsed = {}", (Object)m.group(1));
                continue;
            }
            m = COMMIT_LINE.matcher(line);
            if (m.matches()) {
                log.debug("total = {} mutation count = {} ", (Object)m.group(1), (Object)m.group(2));
                mutationCount = Integer.valueOf(m.group(2));
                continue;
            }
            m = BULK_UPDATE_LINE.matcher(line);
            if (!m.matches()) continue;
            log.debug("bulk updated {} items in {} millis", (Object)m.group(1), (Object)m.group(2));
            mutationCount = Integer.valueOf(m.group(1));
        }
        if (mutationCount == null) {
            throw new IOException("Couldn't find the mutation count!");
        }
        return mutationCount;
    }
}

