/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import java.util.ArrayList;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.test.StatementHelper;

public final class Matchers {
    public static Matcher<BindingSet> binds(String name, String value) {
        if (value.startsWith("P")) {
            value = WikibaseUris.getURISystem().property(WikibaseUris.PropertyType.CLAIM) + value;
        }
        return new BindsMatcher(name, org.hamcrest.Matchers.equalTo((Object)StatementHelper.uri(value)));
    }

    public static Matcher<BindingSet> binds(String name, Class<?> value) {
        return new BindsMatcher(name, org.hamcrest.Matchers.instanceOf(value));
    }

    public static <V> Matcher<BindingSet> binds(String name, V value) {
        return new BindsMatcher(name, org.hamcrest.Matchers.equalTo(value));
    }

    public static Matcher<BindingSet> binds(String name, String str, String language) {
        if (str == null && language == null) {
            return Matchers.notBinds(name);
        }
        return new BindsMatcher(name, org.hamcrest.Matchers.equalTo((Object)new LiteralImpl(str, language)));
    }

    public static Matcher<BindingSet> notBinds(String name) {
        return new NotBindsMatcher(name);
    }

    public static Matcher<BindingSet>[] subjectPredicateObjectMatchers(Iterable<Statement> statements) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (Statement statement : statements) {
            matchers.add(org.hamcrest.Matchers.allOf(Matchers.binds("s", statement.getSubject()), Matchers.binds("p", statement.getPredicate()), Matchers.binds("o", statement.getObject())));
        }
        return matchers.toArray(new Matcher[matchers.size()]);
    }

    @SafeVarargs
    public static void assertResult(TupleQueryResult result, Matcher<BindingSet> ... bindingMatchers) {
        try {
            int position = 0;
            for (Matcher<BindingSet> bindingMatcher : bindingMatchers) {
                Assert.assertTrue((String)("There should be at least " + position + " results"), (boolean)result.hasNext());
                Assert.assertThat((Object)result.next(), bindingMatcher);
                ++position;
            }
            Assert.assertFalse((String)("There should be no more than " + position + " result"), (boolean)result.hasNext());
            result.close();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    private Matchers() {
    }

    private static class NotBindsMatcher
    extends TypeSafeMatcher<BindingSet> {
        private final String name;

        public NotBindsMatcher(String name) {
            this.name = name;
        }

        public void describeTo(Description description) {
            description.appendText("does not contain a binding for").appendValue((Object)this.name);
        }

        protected void describeMismatchSafely(BindingSet item, Description mismatchDescription) {
            Binding binding = item.getBinding(this.name);
            mismatchDescription.appendText("instead it was bound to").appendValue((Object)binding.getValue());
        }

        protected boolean matchesSafely(BindingSet item) {
            return item.getBinding(this.name) == null;
        }
    }

    private static class BindsMatcher<V>
    extends TypeSafeMatcher<BindingSet> {
        private final String name;
        private final Matcher<V> valueMatcher;

        public BindsMatcher(String name, Matcher<V> valueMatcher) {
            this.name = name;
            this.valueMatcher = valueMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("contains a binding from").appendValue((Object)this.name).appendText("to").appendDescriptionOf(this.valueMatcher);
        }

        protected void describeMismatchSafely(BindingSet item, Description mismatchDescription) {
            Binding binding = item.getBinding(this.name);
            if (binding == null) {
                mismatchDescription.appendText("but did not contain such a binding");
                return;
            }
            mismatchDescription.appendText("instead it was bound to").appendValue((Object)binding.getValue());
        }

        protected boolean matchesSafely(BindingSet item) {
            Binding binding = item.getBinding(this.name);
            if (binding == null) {
                return false;
            }
            return this.valueMatcher.matches((Object)binding.getValue());
        }
    }
}

