/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.IntegerLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.wikidata.query.rdf.common.uri.WikibaseUris;

public final class StatementHelper {
    public static Statement statement(String s, String p, Object o) {
        URI oValue;
        if (o instanceof String) {
            oValue = StatementHelper.uri(o.toString());
        } else if (o instanceof Value) {
            oValue = (Value)o;
        } else if (o instanceof Integer) {
            oValue = new IntegerLiteralImpl(BigInteger.valueOf(((Integer)o).intValue()));
        } else if (o instanceof Long) {
            oValue = new IntegerLiteralImpl(BigInteger.valueOf((Long)o));
        } else {
            throw new IllegalArgumentException("Illegal object:  " + o);
        }
        if (p.startsWith("P")) {
            p = WikibaseUris.getURISystem().property(WikibaseUris.PropertyType.CLAIM) + p;
        }
        return new StatementImpl((Resource)StatementHelper.uri(s), StatementHelper.uri(p), (Value)oValue);
    }

    public static Statement statement(List<Statement> statements, String s, String p, Object o) {
        Statement st = StatementHelper.statement(s, p, o);
        statements.add(st);
        return st;
    }

    public static ImmutableList<Statement> siteLink(String entityId, String link, String language) {
        return StatementHelper.siteLink(entityId, link, language, false);
    }

    public static ImmutableList<Statement> siteLink(String entityId, String link, String language, boolean outOfOrder) {
        if (outOfOrder) {
            return ImmutableList.of((Object)StatementHelper.statement(link, "http://schema.org/inLanguage", new LiteralImpl(language)), (Object)StatementHelper.statement(link, "http://schema.org/about", entityId), (Object)StatementHelper.statement(link, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://schema.org/Article"));
        }
        return ImmutableList.of((Object)StatementHelper.statement(link, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://schema.org/Article"), (Object)StatementHelper.statement(link, "http://schema.org/about", entityId), (Object)StatementHelper.statement(link, "http://schema.org/inLanguage", new LiteralImpl(language)));
    }

    public static URI uri(String r) {
        if (r.startsWith("Q") || r.startsWith("P")) {
            return new URIImpl(WikibaseUris.getURISystem().entity() + r);
        }
        return new URIImpl(r);
    }

    public static List<Statement> basicEntity(WikibaseUris uris, String id) {
        LiteralImpl version = new LiteralImpl("a revision number I promise");
        ArrayList<Statement> statements = new ArrayList<Statement>();
        String entityDataUri = uris.entityData() + id;
        StatementHelper.statement(statements, entityDataUri, "http://schema.org/about", id);
        StatementHelper.statement(statements, entityDataUri, "http://schema.org/version", version);
        StatementHelper.statement(statements, entityDataUri, "http://schema.org/dateModified", new LiteralImpl("a date I promise"));
        return statements;
    }

    public static LiteralImpl randomDate() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%04d-%02d-%02d", RandomizedTest.randomIntBetween((int)1, (int)9999), RandomizedTest.randomIntBetween((int)1, (int)12), RandomizedTest.randomIntBetween((int)1, (int)28));
        formatter.close();
        return new LiteralImpl(sb.toString(), XMLSchema.DATE);
    }

    public static List<Statement> randomStatementsAbout(String s, int count) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (int i = 0; i < count; ++i) {
            String p = "P" + RandomizedTest.randomInt();
            LiteralImpl o = StatementHelper.randomDate();
            statements.add(StatementHelper.statement(s, p, o));
        }
        return statements;
    }

    private StatementHelper() {
    }
}

