/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import java.io.Closeable;

public final class SystemPropertyContext
implements Closeable {
    private final String key;
    private final String value;

    private SystemPropertyContext(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static Closeable setProperty(String key, String value) {
        String currentValue = System.getProperty(key);
        System.setProperty(key, value);
        return new SystemPropertyContext(key, currentValue);
    }

    @Override
    public void close() {
        if (this.value == null) {
            System.clearProperty(this.key);
        } else {
            System.setProperty(this.key, this.value);
        }
    }
}

