/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class CloseableRule<T extends AutoCloseable>
implements TestRule {
    private final T closeable;

    public static <T extends AutoCloseable> CloseableRule<T> autoClose(T closeable) {
        return new CloseableRule<T>(closeable);
    }

    private CloseableRule(T closeable) {
        this.closeable = closeable;
    }

    public T get() {
        return this.closeable;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    CloseableRule.this.closeable.close();
                }
            }
        };
    }
}

