/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ManualClock
extends Clock {
    @Nonnull
    private final ZoneId zone;
    @Nonnull
    private Instant now;

    public ManualClock() {
        this(ZoneOffset.UTC, Instant.now());
    }

    public ManualClock(Instant now) {
        this(ZoneOffset.UTC, now);
    }

    public ManualClock(ZoneId zone, Instant now) {
        this.zone = zone;
        this.now = now;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public synchronized Clock withZone(ZoneId zone) {
        return new ManualClock(zone, this.now);
    }

    @Override
    public synchronized Instant instant() {
        return this.now;
    }

    public synchronized void sleep(TemporalAmount duration) {
        this.now = this.now.plus(duration);
    }

    public synchronized void sleepUntil(Instant until) {
        if (until.isBefore(this.now)) {
            throw new IllegalArgumentException("Can't go back in time");
        }
        this.now = until;
    }
}

