/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import java.security.SecureRandom;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Randomizer
implements TestRule {
    private static final String SEED_PROPERTY = Randomizer.class.getName() + ".seed";
    private static final Logger log = LoggerFactory.getLogger(Randomizer.class);
    private Random random;
    private int seed;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Randomizer.this.before();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    Randomizer.this.onError();
                    throw t;
                }
            }
        };
    }

    private void before() {
        this.seed = this.getSeed();
        this.random = new Random(this.seed);
    }

    private void onError() {
        log.info("Ramdomizer initialized with: [{}], you can override it by setting the system property {}.", (Object)this.seed, (Object)SEED_PROPERTY);
    }

    private int getSeed() {
        String seedString = System.getProperty(SEED_PROPERTY);
        if (seedString != null) {
            return Integer.parseInt(seedString);
        }
        return new SecureRandom().nextInt();
    }

    public int randomIntBetween(int min, int max) {
        assert (max >= min) : "max must be >= min: " + min + ", " + max;
        long range = (long)max - (long)min;
        if (range < Integer.MAX_VALUE) {
            return min + this.random.nextInt(1 + (int)range);
        }
        return min + (int)Math.round(this.random.nextDouble() * (double)range);
    }

    public int randomInt(int max) {
        if (max == 0) {
            return 0;
        }
        if (max == Integer.MAX_VALUE) {
            return this.random.nextInt() & Integer.MAX_VALUE;
        }
        return this.random.nextInt(max + 1);
    }

    public boolean randomBoolean() {
        return this.random.nextBoolean();
    }

    public int randomInt() {
        return this.random.nextInt();
    }

    public String randomAsciiOfLength(int count) {
        return RandomStringUtils.randomAlphabetic((int)count);
    }

    public boolean rarely() {
        return this.randomInt(100) >= 90;
    }

    public Random getRandom() {
        return this.random;
    }
}

