/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.test;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.IntegerLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.wikidata.query.rdf.common.uri.PropertyType;
import org.wikidata.query.rdf.common.uri.UrisScheme;
import org.wikidata.query.rdf.common.uri.UrisSchemeFactory;
import org.wikidata.query.rdf.test.Randomizer;

public final class StatementHelper {
    public static Statement statement(String s, String p, Object o) {
        URI oValue;
        if (o instanceof String) {
            oValue = StatementHelper.uri(o.toString());
        } else if (o instanceof Value) {
            oValue = (Value)o;
        } else if (o instanceof Integer) {
            oValue = new IntegerLiteralImpl(BigInteger.valueOf(((Integer)o).intValue()));
        } else if (o instanceof Long) {
            oValue = new IntegerLiteralImpl(BigInteger.valueOf((Long)o));
        } else {
            throw new IllegalArgumentException("Illegal object:  " + o);
        }
        if (p.startsWith("P")) {
            p = UrisSchemeFactory.getURISystem().property(PropertyType.CLAIM) + p;
        }
        return new StatementImpl((Resource)StatementHelper.uri(s), StatementHelper.uri(p), (Value)oValue);
    }

    public static Statement statement(List<Statement> statements, String s, String p, Object o) {
        Statement st = StatementHelper.statement(s, p, o);
        statements.add(st);
        return st;
    }

    public static ImmutableList<Statement> siteLink(String entityId, String link, String language) {
        return StatementHelper.siteLink(entityId, link, language, false);
    }

    public static ImmutableList<Statement> siteLink(String entityId, String link, String language, boolean outOfOrder) {
        if (outOfOrder) {
            return ImmutableList.of((Object)StatementHelper.statement(link, "http://schema.org/inLanguage", new LiteralImpl(language)), (Object)StatementHelper.statement(link, "http://schema.org/about", entityId), (Object)StatementHelper.statement(link, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://schema.org/Article"));
        }
        return ImmutableList.of((Object)StatementHelper.statement(link, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://schema.org/Article"), (Object)StatementHelper.statement(link, "http://schema.org/about", entityId), (Object)StatementHelper.statement(link, "http://schema.org/inLanguage", new LiteralImpl(language)));
    }

    public static URI uri(String r) {
        if (r.startsWith("Q") || r.startsWith("P") || r.startsWith("L") || r.startsWith("M")) {
            return new URIImpl(UrisSchemeFactory.getURISystem().entityIdToURI(r));
        }
        return new URIImpl(r);
    }

    public static List<Statement> basicEntity(UrisScheme uris, String id) {
        return StatementHelper.basicEntity(uris, id, "a revision number I promise", "a date I promise");
    }

    public static List<Statement> basicEntity(UrisScheme uris, String id, String versionString, String dateString) {
        LiteralImpl version = new LiteralImpl(versionString);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        String entityDataUri = uris.entityData() + id;
        StatementHelper.statement(statements, entityDataUri, "http://schema.org/about", id);
        StatementHelper.statement(statements, entityDataUri, "http://schema.org/version", version);
        StatementHelper.statement(statements, entityDataUri, "http://schema.org/dateModified", new LiteralImpl(dateString));
        return statements;
    }

    public static LiteralImpl randomDate(Randomizer randomizer) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%04d-%02d-%02d", randomizer.randomIntBetween(1, 9999), randomizer.randomIntBetween(1, 12), randomizer.randomIntBetween(1, 28));
        formatter.close();
        return new LiteralImpl(sb.toString(), XMLSchema.DATE);
    }

    public static List<Statement> randomStatementsAbout(Randomizer randomizer, String s, int count) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (int i = 0; i < count; ++i) {
            String p = "P" + randomizer.randomInt();
            LiteralImpl o = StatementHelper.randomDate(randomizer);
            statements.add(StatementHelper.statement(s, p, o));
        }
        return statements;
    }

    private StatementHelper() {
    }

    public static class StatementBuilder {
        private List<Statement> statements;
        private final String entityId;
        private String currentStatement;
        private String currentProperty;
        private final UrisScheme uris = UrisSchemeFactory.getURISystem();

        public StatementBuilder(String entityId) {
            this.entityId = entityId;
            this.statements = new ArrayList<Statement>();
        }

        public StatementBuilder withStatement(String propertyId, String statementUri) {
            StatementHelper.statement(this.statements, this.entityId, propertyId, statementUri);
            this.currentStatement = statementUri;
            this.currentProperty = propertyId;
            return this;
        }

        public StatementBuilder withStatementValue(String valueUri) {
            StatementHelper.statement(this.statements, this.currentStatement, this.uris.property(PropertyType.STATEMENT_VALUE) + this.currentProperty, valueUri);
            return this;
        }

        public StatementBuilder withStatementValueNormalized(String valueUri) {
            StatementHelper.statement(this.statements, this.currentStatement, this.uris.property(PropertyType.STATEMENT_VALUE_NORMALIZED) + this.currentProperty, valueUri);
            return this;
        }

        public StatementBuilder withTimeValue(String valueUri, String timeValue) {
            StatementHelper.statement(this.statements, valueUri, "http://wikiba.se/ontology#timeValue", new LiteralImpl(timeValue));
            return this;
        }

        public StatementBuilder withQuanitityValue(String valueUri, String value) {
            StatementHelper.statement(this.statements, valueUri, "http://wikiba.se/ontology#quantityAmount", new LiteralImpl(value));
            return this;
        }

        public StatementBuilder withQuanitityValueNormalized(String valueUri, String value, String normalizedUri, String normalizedValue) {
            StatementHelper.statement(this.statements, valueUri, "http://wikiba.se/ontology#quantityAmount", new LiteralImpl(value));
            StatementHelper.statement(this.statements, normalizedUri, "http://wikiba.se/ontology#quantityAmount", new LiteralImpl(normalizedValue));
            StatementHelper.statement(this.statements, valueUri, "http://wikiba.se/ontology#quantityNormalized", normalizedUri);
            StatementHelper.statement(this.statements, normalizedUri, "http://wikiba.se/ontology#quantityNormalized", normalizedUri);
            return this;
        }

        public StatementBuilder withTimeCalendarValue(String valueUri, String timeValue, String calendar) {
            this.withTimeValue(valueUri, timeValue);
            StatementHelper.statement(this.statements, valueUri, "http://wikiba.se/ontology#timeCalendarModel", new LiteralImpl(calendar));
            return this;
        }

        public StatementBuilder withReference(String referenceUri, String propertyId, String value) {
            StatementHelper.statement(this.statements, this.currentStatement, "http://www.w3.org/ns/prov#wasDerivedFrom", referenceUri);
            StatementHelper.statement(this.statements, referenceUri, this.uris.property(PropertyType.REFERENCE) + propertyId, value);
            return this;
        }

        public StatementBuilder withReferenceValue(String referenceUri, String propertyId, String value) {
            StatementHelper.statement(this.statements, this.currentStatement, "http://www.w3.org/ns/prov#wasDerivedFrom", referenceUri);
            StatementHelper.statement(this.statements, referenceUri, this.uris.property(PropertyType.REFERENCE_VALUE) + propertyId, value);
            return this;
        }

        public StatementBuilder withEntityData(String version, String lastModified) {
            StatementHelper.statement(this.statements, this.uris.entityData() + this.entityId, "http://schema.org/version", new LiteralImpl(version));
            StatementHelper.statement(this.statements, this.uris.entityData() + this.entityId, "http://schema.org/dateModified", new LiteralImpl(lastModified));
            return this;
        }

        public StatementBuilder withPredicateObject(String predicate, Object object) {
            StatementHelper.statement(this.statements, this.entityId, predicate, object);
            return this;
        }

        public List<Statement> build() {
            return this.statements;
        }
    }
}

