/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.wikibase;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.rdf.NormalizingRdfHandler;

public class WikibaseRepository {
    private static final Logger log = LoggerFactory.getLogger(WikibaseRepository.class);
    private final CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(100).setMaxConnTotal(100).build();
    private final Uris uris;

    public WikibaseRepository(String scheme, String host) {
        this.uris = new Uris(scheme, host);
    }

    public JSONObject fetchRecentChanges(Date nextStartTime, JSONObject lastContinue, int batchSize) throws RetryableException {
        URI uri = this.uris.recentChanges(nextStartTime, lastContinue, batchSize);
        log.debug("Polling for changes from {}", (Object)uri);
        try {
            return this.checkApi(this.getJson((HttpRequestBase)new HttpGet(uri)));
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error fetching recent changes", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Statement> fetchRdfForEntity(String entityId) throws RetryableException {
        URI uri = this.uris.rdf(entityId);
        log.debug("Fetching rdf from {}", (Object)uri);
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        StatementCollector collector = new StatementCollector();
        parser.setRDFHandler((RDFHandler)new NormalizingRdfHandler((RDFHandler)collector));
        HttpGet request = new HttpGet(uri);
        this.setNoCookies((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() == 404) {
                List<Statement> list = Collections.emptyList();
                return list;
            }
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new ContainedException("Unexpected status code fetching RDF for " + uri + ":  " + response.getStatusLine().getStatusCode());
            }
            parser.parse((Reader)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8), uri.toString());
            return collector.getStatements();
        }
        catch (IOException e) {
            throw new RetryableException("Error fetching RDF for " + uri, e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new ContainedException("RDF parsing error for " + uri, e);
        }
    }

    public String firstEntityIdForLabelStartingWith(String label, String language, String type) throws RetryableException {
        URI uri = this.uris.searchForLabel(label, language, type);
        log.debug("Searching for entity using {}", (Object)uri);
        try {
            JSONObject result = this.checkApi(this.getJson((HttpRequestBase)new HttpGet(uri)));
            JSONArray resultList = (JSONArray)result.get((Object)"search");
            if (resultList.isEmpty()) {
                return null;
            }
            result = (JSONObject)resultList.get(0);
            return result.get((Object)"id").toString();
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error searching for page", e);
        }
    }

    public String setLabel(String entityId, String type, String label, String language) throws RetryableException {
        JSONObject data = new JSONObject();
        JSONObject labels = new JSONObject();
        data.put((Object)"labels", (Object)labels);
        JSONObject labelObject = new JSONObject();
        labels.put((Object)"en", (Object)labelObject);
        labelObject.put((Object)"language", (Object)language);
        labelObject.put((Object)"value", (Object)(label + System.currentTimeMillis()));
        if (type.equals("property")) {
            data.put((Object)"datatype", (Object)"string");
        }
        URI uri = this.uris.edit(entityId, type, data.toJSONString());
        log.debug("Editing entity using {}", (Object)uri);
        try {
            JSONObject result = this.checkApi(this.getJson((HttpRequestBase)this.postWithToken(uri)));
            return ((JSONObject)result.get((Object)"entity")).get((Object)"id").toString();
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error adding page", e);
        }
    }

    private HttpPost postWithToken(URI uri) throws IOException, ParseException {
        HttpPost request = new HttpPost(uri);
        ArrayList<BasicNameValuePair> entity = new ArrayList<BasicNameValuePair>();
        entity.add(new BasicNameValuePair("token", this.csrfToken()));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(entity, Consts.UTF_8));
        return request;
    }

    private String csrfToken() throws IOException, ParseException {
        URI uri = this.uris.csrfToken();
        log.debug("Fetching csrf token from {}", (Object)uri);
        return ((JSONObject)((JSONObject)this.getJson((HttpRequestBase)new HttpGet(uri)).get((Object)"query")).get((Object)"tokens")).get((Object)"csrftoken").toString();
    }

    private void setNoCookies(HttpRequestBase request) {
        RequestConfig noCookiesConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        request.setConfig(noCookiesConfig);
    }

    private JSONObject getJson(HttpRequestBase request) throws IOException, ParseException {
        this.setNoCookies(request);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            JSONObject jSONObject = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8));
            return jSONObject;
        }
    }

    private JSONObject checkApi(JSONObject response) throws RetryableException {
        Object error = response.get((Object)"error");
        if (error != null) {
            throw new RetryableException("Error result from Mediawiki:  " + error);
        }
        return response;
    }

    public static DateFormat outputDateFormat() {
        return WikibaseRepository.utc(new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT));
    }

    public static DateFormat inputDateFormat() {
        return WikibaseRepository.utc(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT));
    }

    private static DateFormat utc(DateFormat df) {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    public JSONObject getContinueObject(Change lastChange) {
        JSONObject nextContinue = new JSONObject();
        nextContinue.put((Object)"rccontinue", (Object)(WikibaseRepository.outputDateFormat().format(lastChange.timestamp()) + "|" + (lastChange.rcid() + 1L)));
        nextContinue.put((Object)"continue", (Object)"-||");
        return nextContinue;
    }

    private class Uris {
        private final String scheme;
        private final String host;

        public Uris(String scheme, String host) {
            this.scheme = scheme;
            this.host = host;
        }

        public URI recentChanges(Date startTime, JSONObject continueObject, int batchSize) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "query");
            builder.addParameter("list", "recentchanges");
            builder.addParameter("rcdir", "newer");
            builder.addParameter("rcprop", "title|ids|timestamp");
            builder.addParameter("rcnamespace", "0|120");
            builder.addParameter("rclimit", Integer.toString(batchSize));
            if (continueObject == null) {
                builder.addParameter("continue", "");
                builder.addParameter("rcstart", WikibaseRepository.outputDateFormat().format(startTime));
            } else {
                builder.addParameter("continue", continueObject.get((Object)"continue").toString());
                builder.addParameter("rccontinue", continueObject.get((Object)"rccontinue").toString());
            }
            return this.build(builder);
        }

        public URI rdf(String entityId) {
            URIBuilder builder = this.builder();
            builder.setPath(String.format(Locale.ROOT, "/wiki/Special:EntityData/%s.ttl", entityId));
            builder.addParameter("nocache", "1");
            builder.addParameter("flavor", "dump");
            return this.build(builder);
        }

        public URI csrfToken() {
            URIBuilder builder = this.apiBuilder();
            builder.setParameter("action", "query");
            builder.setParameter("meta", "tokens");
            builder.setParameter("continue", "");
            return this.build(builder);
        }

        public URI searchForLabel(String label, String language, String type) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "wbsearchentities");
            builder.addParameter("search", label);
            builder.addParameter("language", language);
            builder.addParameter("type", type);
            return this.build(builder);
        }

        public URI edit(String entityId, String newType, String data) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "wbeditentity");
            if (entityId != null) {
                builder.addParameter("id", entityId);
            } else {
                builder.addParameter("new", newType);
            }
            builder.addParameter("data", data);
            return this.build(builder);
        }

        private URIBuilder apiBuilder() {
            URIBuilder builder = this.builder();
            builder.setPath("/w/api.php");
            builder.addParameter("format", "json");
            return builder;
        }

        private URIBuilder builder() {
            URIBuilder builder = new URIBuilder();
            builder.setHost(this.host);
            builder.setScheme(this.scheme);
            return builder;
        }

        private URI build(URIBuilder builder) {
            try {
                return builder.build();
            }
            catch (URISyntaxException e) {
                throw new FatalException("Unable to build url!?", e);
            }
        }
    }
}

