/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikibaseDate {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("(?<year>[+-]?0+)-(?<month>0?0)-(?<day>0?0)(?:T(?<hour>0?0):(?<minute>0?0)(?::(?<second>0?0)(?<ms>[.]000)?)?)?Z?".replace("0", "\\d"));
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final int SECONDS_PER_MINUTE = (int)TimeUnit.MINUTES.toSeconds(1L);
    private static final int SECONDS_PER_HOUR = (int)TimeUnit.HOURS.toSeconds(1L);
    private static final int SECONDS_PER_DAY = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final long AVERAGE_SECONDS_PER_YEAR = (SECONDS_PER_DAY * 365 * 3 + SECONDS_PER_DAY * 366) / 4;
    private static final long SECONDS_AT_EPOCH = 1970L * AVERAGE_SECONDS_PER_YEAR;
    static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] SECONDS_PER_MONTH = new long[12];
    private static final long[] SECONDS_PER_MONTH_CUMULATIVE = new long[12];
    private static final long[] SECONDS_PER_MONTH_CUMULATIVE_LEAP_YEAR;
    private final long year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;

    static {
        long total = 0L;
        int i = 0;
        while (i < DAYS_PER_MONTH.length) {
            WikibaseDate.SECONDS_PER_MONTH[i] = TimeUnit.DAYS.toSeconds(DAYS_PER_MONTH[i]);
            WikibaseDate.SECONDS_PER_MONTH_CUMULATIVE[i] = total;
            total += SECONDS_PER_MONTH[i];
            ++i;
        }
        SECONDS_PER_MONTH_CUMULATIVE_LEAP_YEAR = Arrays.copyOf(SECONDS_PER_MONTH_CUMULATIVE, SECONDS_PER_MONTH_CUMULATIVE.length);
        i = 2;
        while (i < SECONDS_PER_MONTH_CUMULATIVE_LEAP_YEAR.length) {
            int n = i++;
            SECONDS_PER_MONTH_CUMULATIVE_LEAP_YEAR[n] = SECONDS_PER_MONTH_CUMULATIVE_LEAP_YEAR[n] + (long)SECONDS_PER_DAY;
        }
    }

    public static WikibaseDate fromString(String string) {
        Matcher m = FORMAT_PATTERN.matcher(string);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid date format:  " + string);
        }
        long year = Long.parseLong(m.group("year"));
        int month = Integer.parseInt(m.group("month"));
        int day = Integer.parseInt(m.group("day"));
        int hour = WikibaseDate.parseOr0(m, "hour");
        int minute = WikibaseDate.parseOr0(m, "minute");
        int second = WikibaseDate.parseOr0(m, "second");
        return new WikibaseDate(year, month, day, hour, minute, second);
    }

    private static int parseOr0(Matcher m, String group) {
        String matched = m.group(group);
        if (matched == null) {
            return 0;
        }
        return Integer.parseInt(matched);
    }

    public static WikibaseDate fromSecondsSinceEpoch(long secondsSinceEpoch) {
        long year = WikibaseDate.yearFromSecondsSinceEpoch(secondsSinceEpoch);
        int second = (int)(secondsSinceEpoch - WikibaseDate.calculateFirstDayOfYear(year) * (long)SECONDS_PER_DAY);
        int month = 1;
        long[] secondsPerMonthCumulative = WikibaseDate.secondsPerMonthCumulative(year);
        while (month < 12 && (long)second >= secondsPerMonthCumulative[month]) {
            ++month;
        }
        second = (int)((long)second - secondsPerMonthCumulative[month - 1]);
        int day = second / SECONDS_PER_DAY + 1;
        int hour = (second %= SECONDS_PER_DAY) / SECONDS_PER_HOUR;
        int minute = (second %= SECONDS_PER_HOUR) / SECONDS_PER_MINUTE;
        return new WikibaseDate(year, month, day, hour, minute, second %= SECONDS_PER_MINUTE);
    }

    public WikibaseDate(long year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public WikibaseDate cleanWeirdStuff() {
        long newYear = this.year;
        int newMonth = this.month;
        int newDay = this.day;
        if (this.month == 0) {
            newMonth = 1;
        }
        if (this.day == 0) {
            newDay = 1;
        } else {
            int maxDaysInMonth = WikibaseDate.daysInMonth(newYear, newMonth);
            if (newDay > maxDaysInMonth) {
                newDay = newDay - maxDaysInMonth + 1;
                if (++newMonth > 12) {
                    newMonth -= 12;
                    ++newYear;
                }
            }
        }
        if (newYear == this.year && newMonth == this.month && newDay == this.day) {
            return this;
        }
        return new WikibaseDate(newYear, newMonth, newDay, this.hour, this.minute, this.second);
    }

    public long secondsSinceEpoch() {
        long seconds = WikibaseDate.calculateFirstDayOfYear(this.year) * (long)SECONDS_PER_DAY;
        seconds += SECONDS_PER_MONTH_CUMULATIVE[this.month - 1];
        seconds += (long)((this.day - 1) * SECONDS_PER_DAY);
        seconds += (long)(this.hour * SECONDS_PER_HOUR);
        seconds += (long)(this.minute * SECONDS_PER_MINUTE);
        seconds += (long)this.second;
        if (this.month > 2 && WikibaseDate.isLeapYear(this.year)) {
            seconds += (long)SECONDS_PER_DAY;
        }
        return seconds;
    }

    public String toString(ToStringFormat format) {
        return format.format(this);
    }

    public String toString() {
        return this.toString(ToStringFormat.WIKIDATA);
    }

    public long year() {
        return this.year;
    }

    public int month() {
        return this.month;
    }

    public int day() {
        return this.day;
    }

    public int hour() {
        return this.hour;
    }

    public int minute() {
        return this.minute;
    }

    public int second() {
        return this.second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.day;
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.month;
        result = 31 * result + this.second;
        result = 31 * result + (int)(this.year ^ this.year >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WikibaseDate other = (WikibaseDate)obj;
        if (this.day != other.day) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        if (this.minute != other.minute) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.second != other.second) {
            return false;
        }
        return this.year == other.year;
    }

    static boolean isLeapYear(long year) {
        return (year & 3L) == 0L && (year % 100L != 0L || year % 400L == 0L);
    }

    static long calculateFirstDayOfYear(long year) {
        long leapYears = year / 100L;
        if (year < 0L) {
            leapYears = (year + 3L >> 2) - leapYears + (leapYears + 3L >> 2) - 1L;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (WikibaseDate.isLeapYear(year)) {
                --leapYears;
            }
        }
        return year * 365L + leapYears - 719527L;
    }

    static long yearFromSecondsSinceEpoch(long secondsSinceEpoch) {
        long unitSeconds = AVERAGE_SECONDS_PER_YEAR / 2L;
        long i2 = secondsSinceEpoch / 2L + SECONDS_AT_EPOCH / 2L;
        if (i2 < 0L) {
            i2 = i2 - unitSeconds + 1L;
        }
        long year = i2 / unitSeconds;
        while (true) {
            long yearStart;
            long diff;
            if ((diff = secondsSinceEpoch - (yearStart = WikibaseDate.calculateFirstDayOfYear(year) * (long)SECONDS_PER_DAY)) < 0L) {
                --year;
                continue;
            }
            if (diff < (long)(SECONDS_PER_DAY * 365)) break;
            yearStart += (long)(SECONDS_PER_DAY * 365);
            if (WikibaseDate.isLeapYear(year)) {
                yearStart += (long)SECONDS_PER_DAY;
            }
            if (yearStart > secondsSinceEpoch) break;
            ++year;
        }
        return year;
    }

    static long[] secondsPerMonthCumulative(long year) {
        if (WikibaseDate.isLeapYear(year)) {
            return SECONDS_PER_MONTH_CUMULATIVE_LEAP_YEAR;
        }
        return SECONDS_PER_MONTH_CUMULATIVE;
    }

    private static int daysInMonth(long year, int month) {
        int d = DAYS_PER_MONTH[month - 1];
        if (month == 2 && WikibaseDate.isLeapYear(year)) {
            ++d;
        }
        return d;
    }

    public static enum ToStringFormat {
        WIKIDATA{

            @Override
            public String format(WikibaseDate date) {
                return String.format(Locale.ROOT, "%+012d-%02d-%02dT%02d:%02d:%02dZ", date.year, date.month, date.day, date.hour, date.minute, date.second);
            }
        }
        ,
        DATE_TIME{

            @Override
            public String format(WikibaseDate date) {
                return String.format(Locale.ROOT, "%04d-%02d-%02dT%02d:%02d:%02dZ", date.year, date.month, date.day, date.hour, date.minute, date.second);
            }
        }
        ,
        DATE{

            @Override
            public String format(WikibaseDate date) {
                return String.format(Locale.ROOT, "%04d-%02d-%02d", date.year, date.month, date.day);
            }
        };


        public abstract String format(WikibaseDate var1);
    }
}

