/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.base.Splitter;
import com.google.common.io.Resources;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.Cli;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.HelpRequestedException;
import com.lexicalscope.jewel.cli.Option;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.CliUtils;
import org.wikidata.query.rdf.tool.rdf.Munger;

public final class OptionsUtils {
    private static final Logger log = LoggerFactory.getLogger(OptionsUtils.class);

    public static <T extends BasicOptions> T handleOptions(Class<T> optionsClass, String ... args) {
        BasicOptions options = (BasicOptions)OptionsUtils.parseOptions(optionsClass, args);
        if (options.verbose()) {
            log.info("Verbose mode activated");
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)context);
                context.reset();
                configurator.doConfigure(Resources.getResource((String)"logback-verbose.xml"));
            }
            catch (JoranException joranException) {
                // empty catch block
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        return (T)options;
    }

    private static List<String> splitByComma(List<String> options) {
        LinkedList<String> newOptions = new LinkedList<String>();
        for (String option : options) {
            if (option.contains(",")) {
                newOptions.addAll(Splitter.on((String)",").splitToList((CharSequence)option));
                continue;
            }
            newOptions.add(option);
        }
        return newOptions;
    }

    public static Munger mungerFromOptions(MungerOptions options) {
        Munger munger = new Munger(new WikibaseUris(options.wikibaseHost()));
        if (options.skipSiteLinks()) {
            munger = munger.removeSiteLinks();
        }
        if (options.labelLanguages() != null) {
            munger = munger.limitLabelLanguages(OptionsUtils.splitByComma(options.labelLanguages()));
        }
        if (options.singleLabelLanguages() != null) {
            munger = munger.singleLabelMode(OptionsUtils.splitByComma(options.singleLabelLanguages()));
        }
        return munger;
    }

    private static <T> T parseOptions(Class<T> optionsClass, String ... args) {
        Cli cli = CliFactory.createCli(optionsClass);
        try {
            return (T)cli.parseArguments(args);
        }
        catch (HelpRequestedException e) {
            CliUtils.ForbiddenOk.systemDotOut().println(cli.getHelpMessage());
            System.exit(0);
        }
        catch (ArgumentValidationException e) {
            CliUtils.ForbiddenOk.systemDotErr().println("Invalid argument:  " + (Object)((Object)e));
            CliUtils.ForbiddenOk.systemDotErr().println(cli.getHelpMessage());
            System.exit(1);
        }
        throw new RuntimeException("Should be unreachable.");
    }

    private OptionsUtils() {
    }

    public static interface BasicOptions {
        @Option(shortName={"v"}, description="Verbose mode")
        public boolean verbose();

        @Option(helpRequest=true, description="Show this message")
        public boolean help();
    }

    public static interface MungerOptions
    extends WikibaseOptions {
        @Option(longName={"labelLanguage"}, defaultToNull=true, description="Only import labels, aliases, and descriptions in these languages.")
        public List<String> labelLanguages();

        @Option(longName={"singleLabel"}, defaultToNull=true, description="Only import a single label and description using the languages specified as a fallback list. If there isn't a label in any of the specified languages then no label is imported.  Ditto for description.")
        public List<String> singleLabelLanguages();

        @Option(description="Skip site links")
        public boolean skipSiteLinks();
    }

    public static interface WikibaseOptions {
        @Option(shortName={"w"}, defaultValue={"www.wikidata.org"}, description="Wikibase host")
        public String wikibaseHost();
    }
}

