/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.wikidata.query.rdf.tool.exception.RetryableException;

public class Change
implements Comparable<Change> {
    private final String entityId;
    private final long revision;
    private final Date timestamp;
    private final long rcid;

    public Change(String entityId, long revision, Date timestamp, long rcid) {
        this.entityId = entityId.startsWith("Property:") ? entityId.substring("Property:".length()) : entityId;
        this.revision = revision;
        this.timestamp = timestamp;
        this.rcid = rcid;
    }

    public String entityId() {
        return this.entityId;
    }

    public long revision() {
        return this.revision;
    }

    public long rcid() {
        return this.rcid;
    }

    public Date timestamp() {
        return this.timestamp;
    }

    public String toString() {
        if (this.revision < -1L && this.timestamp == null) {
            return this.entityId;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.entityId);
        if (this.revision >= 0L) {
            b.append('@').append(this.revision);
        }
        if (this.timestamp != null) {
            b.append("@").append(this.timestamp);
        }
        return b.toString();
    }

    @Override
    public int compareTo(Change o) {
        return (int)(this.rcid() - o.rcid());
    }

    public static interface Batch {
        public List<Change> changes();

        public String advancedUnits();

        public long advanced();

        public String leftOffHuman();

        public Date leftOffDate();

        public boolean last();

        public static abstract class AbstractDefaultImplementation
        implements Batch {
            private final ImmutableList<Change> changes;
            private final long advanced;
            private final Object leftOff;

            public AbstractDefaultImplementation(ImmutableList<Change> changes, long advanced, Object leftOff) {
                this.changes = (ImmutableList)Preconditions.checkNotNull(changes);
                this.advanced = advanced;
                this.leftOff = leftOff;
            }

            @Override
            public List<Change> changes() {
                return this.changes;
            }

            @Override
            public long advanced() {
                return this.advanced;
            }

            @Override
            public String leftOffHuman() {
                return this.leftOff.toString();
            }

            @Override
            public boolean last() {
                return false;
            }
        }
    }

    public static interface Source<B extends Batch> {
        public B firstBatch() throws RetryableException;

        public B nextBatch(B var1) throws RetryableException;
    }
}

