/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.binary.BinaryQueryResultParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.Ontology;
import org.wikidata.query.rdf.common.uri.SchemaDotOrg;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.FilteredStatements;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.rdf.UpdateBuilder;

public class RdfRepository {
    private static final Logger log = LoggerFactory.getLogger(RdfRepository.class);
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(100).setMaxConnTotal(100).build();
    private final URI uri;
    private final WikibaseUris uris;
    private final String syncBody;
    private final String getValues;
    private final String getRefs;
    private final String cleanUnused;
    private final String updateLeftOffTimeBody;
    private int maxRetries = 5;
    private int delay = 2000;
    protected static final ResponseHandler<Integer> UPDATE_COUNT_RESPONSE = new UpdateCountResponse();
    protected static final ResponseHandler<TupleQueryResult> TUPLE_QUERY_RESPONSE = new TupleQueryResponse();
    protected static final ResponseHandler<Boolean> ASK_QUERY_RESPONSE = new AskQueryResponse();

    protected CloseableHttpClient client() {
        return this.client;
    }

    public RdfRepository(URI uri, WikibaseUris uris) {
        this.uri = uri;
        this.uris = uris;
        this.syncBody = RdfRepository.loadBody("sync");
        this.updateLeftOffTimeBody = RdfRepository.loadBody("updateLeftOffTime");
        this.getValues = RdfRepository.loadBody("GetValues");
        this.getRefs = RdfRepository.loadBody("GetRefs");
        this.cleanUnused = RdfRepository.loadBody("CleanUnused");
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RdfRepository setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public RdfRepository setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    private static String loadBody(String name) {
        URL url = Resources.getResource(RdfRepository.class, (String)("RdfRepository." + name + ".sparql"));
        try {
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new FatalException("Can't load " + url);
        }
    }

    private Set<String> resultToSet(TupleQueryResult result, String binding) {
        HashSet<String> values = new HashSet<String>();
        try {
            while (result.hasNext()) {
                Binding value = ((BindingSet)result.next()).getBinding(binding);
                if (value == null) continue;
                values.add(value.getValue().stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new FatalException("Can't load results: " + (Object)((Object)e), e);
        }
        return values;
    }

    public Set<String> getValues(String entityId) {
        UpdateBuilder b = new UpdateBuilder(this.getValues);
        b.bindUri("entity:id", String.valueOf(this.uris.entity()) + entityId);
        b.bind("uris.value", this.uris.value());
        b.bind("uris.statement", this.uris.statement());
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        return this.resultToSet(this.query(b.toString()), "s");
    }

    public Set<String> getRefs(String entityId) {
        UpdateBuilder b = new UpdateBuilder(this.getRefs);
        b.bindUri("entity:id", String.valueOf(this.uris.entity()) + entityId);
        b.bind("uris.statement", this.uris.statement());
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        return this.resultToSet(this.query(b.toString()), "s");
    }

    public int sync(String entityId, Collection<Statement> statements, Collection<String> valueList) {
        log.debug("Updating data for {}", (Object)entityId);
        UpdateBuilder b = new UpdateBuilder(this.syncBody);
        b.bindUri("entity:id", String.valueOf(this.uris.entity()) + entityId);
        b.bindUri("schema:about", "http://schema.org/about");
        b.bindUri("prov:wasDerivedFrom", "http://www.w3.org/ns/prov#wasDerivedFrom");
        b.bind("uris.value", this.uris.value());
        b.bind("uris.statement", this.uris.statement());
        b.bindStatements("insertStatements", statements);
        Collection<Statement> entityStatements = FilteredStatements.filtered(statements).withSubject(String.valueOf(this.uris.entity()) + entityId);
        b.bindValues("entityStatements", entityStatements);
        Collection<Statement> statementStatements = FilteredStatements.filtered(statements).withSubjectStarts(this.uris.statement());
        b.bindValues("statementStatements", statementStatements);
        HashSet<Statement> aboutStatements = new HashSet<Statement>(statements);
        aboutStatements.removeAll(entityStatements);
        aboutStatements.removeAll(statementStatements);
        b.bindValues("valueStatements", aboutStatements);
        if (valueList != null && !valueList.isEmpty()) {
            UpdateBuilder cleanup = new UpdateBuilder(this.cleanUnused);
            cleanup.bindUris("values", valueList);
            b.bind("cleanupQuery", cleanup.toString());
        } else {
            b.bind("cleanupQuery", "");
        }
        long start = System.currentTimeMillis();
        int modified = this.execute("update", UPDATE_COUNT_RESPONSE, b.toString());
        log.debug("Updating {} took {} millis and modified {} statements", new Object[]{entityId, System.currentTimeMillis() - start, modified});
        return modified;
    }

    public int sync(String entityId, Collection<Statement> statements) {
        return this.sync(entityId, statements, null);
    }

    public boolean hasRevision(String entityId, long revision) {
        StringBuilder prefixes = new StringBuilder();
        prefixes.append("PREFIX schema: <").append("http://schema.org/").append(">\n");
        prefixes.append("PREFIX entity: <").append(this.uris.entity()).append(">\n");
        return this.ask(String.format(Locale.ROOT, "%sASK {\n  entity:%s schema:version ?v .\n  FILTER (?v >= %s)\n}", prefixes, entityId, revision));
    }

    public Date fetchLeftOffTime() {
        log.info("Checking for left off time from the updater");
        StringBuilder b = SchemaDotOrg.prefix((StringBuilder)new StringBuilder());
        b.append("SELECT * WHERE { <").append(this.uris.root()).append("> schema:dateModified ?date }");
        Date leftOffTime = this.dateFromQuery(b.toString());
        if (leftOffTime != null) {
            log.info("Found left off time from the updater");
            return leftOffTime;
        }
        log.info("Checking for left off time from the dump");
        b = Ontology.prefix((StringBuilder)SchemaDotOrg.prefix((StringBuilder)new StringBuilder()));
        b.append("SELECT * WHERE { ontology:Dump schema:dateModified ?date }");
        return this.dateFromQuery(b.toString());
    }

    public void updateLeftOffTime(Date leftOffTime) {
        log.debug("Setting last updated time to {}", (Object)leftOffTime);
        UpdateBuilder b = new UpdateBuilder(this.updateLeftOffTimeBody);
        b.bindUri("root", this.uris.root());
        b.bindUri("dateModified", "http://schema.org/dateModified");
        GregorianCalendar c = new GregorianCalendar(UTC, Locale.ROOT);
        c.setTime(leftOffTime);
        try {
            b.bindValue("date", DatatypeFactory.newInstance().newXMLGregorianCalendar(c));
        }
        catch (DatatypeConfigurationException e) {
            throw new FatalException("Holy cow datatype configuration exception on default datatype factory.  Seems like something really really strange.", e);
        }
        this.execute("update", UPDATE_COUNT_RESPONSE, b.toString());
    }

    public boolean ask(String sparql) {
        return this.execute("query", ASK_QUERY_RESPONSE, sparql);
    }

    public TupleQueryResult query(String sparql) {
        return this.execute("query", TUPLE_QUERY_RESPONSE, sparql);
    }

    protected <T> T execute(String type, ResponseHandler<T> responseHandler, String sparql) {
        HttpPost post = new HttpPost(this.uri);
        post.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"));
        if (responseHandler.acceptHeader() != null) {
            post.setHeader((Header)new BasicHeader("Accept", responseHandler.acceptHeader()));
        }
        log.debug("Running SPARQL: {}", (Object)sparql);
        long startQuery = System.currentTimeMillis();
        ArrayList<BasicNameValuePair> entity = new ArrayList<BasicNameValuePair>();
        entity.add(new BasicNameValuePair(type, sparql));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(entity, Consts.UTF_8));
        int retries = 0;
        while (true) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);){
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new ContainedException("Non-200 response from triple store:  " + response + " body=\n" + this.responseBodyAsString(response));
                    }
                    log.debug("Completed in {} ms", (Object)(System.currentTimeMillis() - startQuery));
                    return responseHandler.parse(response.getEntity());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (retries < this.maxRetries) {
                    int retryIn = (int)Math.ceil((double)(this.delay * (retries + 1)) * (1.0 + Math.random() * 0.1));
                    log.info("HTTP request failed: {}, retrying in {} ms", (Object)e, (Object)retryIn);
                    ++retries;
                    try {
                        Thread.sleep(retryIn);
                    }
                    catch (InterruptedException e1) {
                        throw new FatalException("Interrupted", e);
                    }
                    continue;
                }
                throw new FatalException("Error updating triple store", e);
            }
            break;
        }
    }

    protected String responseBodyAsString(CloseableHttpResponse response) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
    }

    private Date dateFromQuery(String query) {
        Binding maxLastUpdate;
        block5: {
            TupleQueryResult result;
            block4: {
                result = this.query(query);
                try {
                    if (result.hasNext()) break block4;
                    return null;
                }
                catch (QueryEvaluationException e) {
                    throw new FatalException("Error evaluating query", e);
                }
            }
            maxLastUpdate = ((BindingSet)result.next()).getBinding("date");
            if (maxLastUpdate != null) break block5;
            return null;
        }
        XMLGregorianCalendar xmlCalendar = ((Literal)maxLastUpdate.getValue()).calendarValue();
        GregorianCalendar calendar = xmlCalendar.toGregorianCalendar();
        return calendar.getTime();
    }

    private static class AskQueryResponse
    implements ResponseHandler<Boolean> {
        private AskQueryResponse() {
        }

        @Override
        public String acceptHeader() {
            return "application/json";
        }

        @Override
        public Boolean parse(HttpEntity entity) throws IOException {
            try {
                JSONObject response = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(entity.getContent(), Charsets.UTF_8));
                return (Boolean)response.get((Object)"boolean");
            }
            catch (ParseException e) {
                throw new IOException("Error parsing response", e);
            }
        }
    }

    private static interface ResponseHandler<T> {
        public String acceptHeader();

        public T parse(HttpEntity var1) throws IOException;
    }

    private static class TupleQueryResponse
    implements ResponseHandler<TupleQueryResult> {
        private TupleQueryResponse() {
        }

        @Override
        public String acceptHeader() {
            return "application/x-binary-rdf-results-table";
        }

        @Override
        public TupleQueryResult parse(HttpEntity entity) throws IOException {
            BinaryQueryResultParser p = new BinaryQueryResultParser();
            TupleQueryResultBuilder collector = new TupleQueryResultBuilder();
            p.setQueryResultHandler((QueryResultHandler)collector);
            try {
                p.parseQueryResult(entity.getContent());
            }
            catch (IllegalStateException | QueryResultHandlerException | QueryResultParseException e) {
                throw new RuntimeException("Error parsing query", e);
            }
            return collector.getQueryResult();
        }
    }

    protected static class UpdateCountResponse
    implements ResponseHandler<Integer> {
        private static final Pattern ELAPSED_LINE = Pattern.compile("><p>totalElapsed=[^ ]+ elapsed=([^<]+)</p");
        private static final Pattern COMMIT_LINE = Pattern.compile("><hr><p>COMMIT: totalElapsed=[^ ]+ commitTime=[^ ]+ mutationCount=([^<]+)</p");
        private static final Pattern BULK_UPDATE_LINE = Pattern.compile("<\\?xml version=\"1.0\"\\?><data modified=\"(\\d+)\" milliseconds=\"(\\d+)\"/>");

        protected UpdateCountResponse() {
        }

        @Override
        public String acceptHeader() {
            return null;
        }

        @Override
        public Integer parse(HttpEntity entity) throws IOException {
            Integer mutationCount = null;
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), Charsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m = ELAPSED_LINE.matcher(line);
                    if (m.matches()) {
                        log.trace("elapsed = {}", (Object)m.group(1));
                        continue;
                    }
                    m = COMMIT_LINE.matcher(line);
                    if (m.matches()) {
                        log.debug("mutation count = {}", (Object)m.group(1));
                        mutationCount = Integer.valueOf(m.group(1));
                        continue;
                    }
                    m = BULK_UPDATE_LINE.matcher(line);
                    if (!m.matches()) continue;
                    log.debug("bulk updated {} items in {} millis", (Object)m.group(1), (Object)m.group(2));
                    mutationCount = Integer.valueOf(m.group(1));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (mutationCount == null) {
                throw new IOException("Couldn't find the mutation count!");
            }
            return mutationCount;
        }
    }
}

