/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.codahale.metrics.Meter;
import com.lexicalscope.jewel.cli.Option;
import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.Rio;
import org.openrdf.rio.turtle.TurtleParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.CliUtils;
import org.wikidata.query.rdf.tool.OptionsUtils;
import org.wikidata.query.rdf.tool.StreamUtils;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.rdf.Munger;
import org.wikidata.query.rdf.tool.rdf.NormalizingRdfHandler;
import org.wikidata.query.rdf.tool.rdf.PrefixRecordingRdfHandler;

public class Munge
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Munge.class);
    private final WikibaseUris uris;
    private final Munger munger;
    private final Reader from;
    private final OutputPicker<Writer> to;

    public static void main(String[] args) {
        OutputPicker<Writer> to;
        Options options = OptionsUtils.handleOptions(Options.class, args);
        WikibaseUris uris = new WikibaseUris(options.wikibaseHost());
        Munger munger = OptionsUtils.mungerFromOptions(options);
        int port = Munge.parsePort(options.to());
        Httpd httpd = null;
        try {
            if (options.chunkSize() > 0) {
                if (port > 0) {
                    ArrayBlockingQueue<InputStream> queue = new ArrayBlockingQueue<InputStream>(2);
                    httpd = new Httpd(port, queue);
                    to = new ChunkedPipedWriterOutputPicker(queue, options.chunkSize());
                } else {
                    to = new ChunkedFileWriterOutputPicker(options.to(), options.chunkSize());
                }
            } else if (port > 0) {
                PipedInputStream toHttp = new PipedInputStream();
                Writer writer = StreamUtils.utf8(new PipedOutputStream(toHttp));
                ArrayBlockingQueue<InputStream> queue = new ArrayBlockingQueue<InputStream>(1);
                queue.put(toHttp);
                httpd = new Httpd(port, queue);
                to = new AlwaysOutputPicker<Writer>(writer);
            } else {
                to = new AlwaysOutputPicker<Writer>(CliUtils.writer(options.to()));
            }
            if (httpd != null) {
                log.info("Starting embedded http sever on port {}", (Object)port);
                log.info("This process will exit when the whole dump has been served");
                httpd.start();
            }
        }
        catch (IOException e) {
            log.error("Error finding output", (Throwable)e);
            System.exit(1);
            return;
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting on httpd", (Throwable)e);
            System.exit(1);
            return;
        }
        try {
            Munge munge = new Munge(uris, munger, Munge.openInput(options.from()), to);
            munge.run();
        }
        catch (RuntimeException e) {
            log.error("Fatal error munging RDF", (Throwable)e);
            System.exit(1);
        }
        Munge.waitForHttpdToShutDownIfNeeded(httpd);
    }

    private static int parsePort(String to) {
        if (to.startsWith("port:")) {
            return Integer.parseInt(to.substring("port:".length()));
        }
        return 0;
    }

    private static Reader openInput(String from) {
        try {
            return CliUtils.reader(from);
        }
        catch (IOException e) {
            log.error("Error finding input", (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    private static void waitForHttpdToShutDownIfNeeded(Httpd httpd) {
        if (httpd == null) {
            return;
        }
        log.info("Finished munging and waiting for the http server to finish sending them");
        while (httpd.busy.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.info("Interrupted while waiting for http server to finish sending", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public Munge(WikibaseUris uris, Munger munger, Reader from, OutputPicker<Writer> to) {
        this.uris = uris;
        this.munger = munger;
        this.from = from;
        this.to = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ForbiddenOk.HackedTurtleParser parser = new ForbiddenOk.HackedTurtleParser();
            WriterToRDFWriterChunkPicker writer = new WriterToRDFWriterChunkPicker(this.to);
            EntityMungingRdfHandler handler = new EntityMungingRdfHandler(this.uris, this.munger, writer);
            parser.setRDFHandler(new NormalizingRdfHandler(handler));
            try {
                parser.parse(this.from, this.uris.entity());
            }
            catch (IOException | RDFHandlerException | RDFParseException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                this.from.close();
            }
            catch (IOException e) {
                log.error("Error closing input", (Throwable)e);
            }
            try {
                this.to.output().close();
            }
            catch (IOException e) {
                log.error("Error closing output", (Throwable)e);
            }
        }
    }

    private static class ForbiddenOk {
        private ForbiddenOk() {
        }

        private static class HackedTurtleParser
        extends TurtleParser {
            private HackedTurtleParser() {
            }

            protected URI parseURI() throws IOException, RDFParseException {
                try {
                    return super.parseURI();
                }
                catch (RDFParseException e) {
                    if (e.getMessage().startsWith("IRI includes string escapes: ") || e.getMessage().startsWith("IRI included an unencoded space: '32'")) {
                        log.warn("Attempting to recover from", (Throwable)e);
                        if (!e.getMessage().startsWith("IRI includes string escapes: '\\62'")) {
                            while (this.readCodePoint() != 62) {
                            }
                        }
                        return super.resolveURI("http://example.com/error");
                    }
                    throw e;
                }
            }

            protected void parseStatement() throws IOException, RDFParseException, RDFHandlerException {
                block3: {
                    try {
                        super.parseStatement();
                    }
                    catch (RDFParseException e) {
                        if (!e.getMessage().startsWith("Namespace prefix 'Warning' used but not defined")) break block3;
                        log.warn("Attempting to recover from", (Throwable)e);
                        while (this.readCodePoint() != 10) {
                        }
                    }
                }
            }
        }
    }

    private static class WriterToRDFWriterChunkPicker
    implements OutputPicker<RDFHandler> {
        private final Map<String, String> prefixes = new LinkedHashMap<String, String>();
        private final OutputPicker<Writer> next;
        private Writer lastWriter;
        private RDFHandler handler;

        public WriterToRDFWriterChunkPicker(OutputPicker<Writer> next) {
            this.next = next;
            this.lastWriter = next.output();
            try {
                this.setHandlerFromLastWriter();
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException("Error setting up first rdf writer", e);
            }
        }

        @Override
        public RDFHandler output() {
            Writer nextWriter = this.next.output();
            if (nextWriter == this.lastWriter) {
                return this.handler;
            }
            try {
                this.handler.endRDF();
                this.lastWriter.close();
                this.lastWriter = nextWriter;
                this.setHandlerFromLastWriter();
                this.handler.startRDF();
            }
            catch (IOException | RDFHandlerException e) {
                throw new RuntimeException("Error switching chunks", e);
            }
            return this.handler;
        }

        @Override
        public void entitiesMunged(int entitiesMunged) {
            this.next.entitiesMunged(entitiesMunged);
        }

        private void setHandlerFromLastWriter() throws RDFHandlerException {
            this.handler = Rio.createWriter((RDFFormat)RDFFormat.TURTLE, (Writer)this.lastWriter);
            this.handler = new PrefixRecordingRdfHandler(this.handler, this.prefixes);
            for (Map.Entry<String, String> prefix : this.prefixes.entrySet()) {
                this.handler.handleNamespace(prefix.getKey(), prefix.getValue());
            }
        }
    }

    public static class ChunkedPipedWriterOutputPicker
    extends ChunkedWriterOutputPicker {
        private final BlockingQueue<InputStream> queue;

        public ChunkedPipedWriterOutputPicker(BlockingQueue<InputStream> queue, int chunkSize) {
            super(chunkSize);
            this.queue = queue;
        }

        @Override
        protected Writer buildWriter(long chunk) {
            PipedInputStream toQueue = new PipedInputStream();
            try {
                this.queue.put(toQueue);
                return StreamUtils.utf8(new PipedOutputStream(toQueue));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Error switching chunks", e);
            }
        }
    }

    public static class ChunkedFileWriterOutputPicker
    extends ChunkedWriterOutputPicker {
        private final String pattern;

        public ChunkedFileWriterOutputPicker(String pattern, int chunkSize) {
            super(chunkSize);
            this.pattern = pattern;
        }

        @Override
        protected Writer buildWriter(long chunk) {
            String file = String.format(Locale.ROOT, this.pattern, chunk);
            log.info("Switching to {}", (Object)file);
            try {
                return CliUtils.writer(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Error switching chunks", e);
            }
        }
    }

    private static abstract class ChunkedWriterOutputPicker
    implements OutputPicker<Writer> {
        private final int chunkSize;
        private Writer writer;
        private int lastChunk = 1;

        public ChunkedWriterOutputPicker(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        public Writer output() {
            if (this.writer == null) {
                this.writer = this.buildWriter(this.lastChunk);
            }
            return this.writer;
        }

        @Override
        public void entitiesMunged(int entitiesMunged) {
            int currentChunk = entitiesMunged / this.chunkSize + 1;
            if (this.lastChunk != currentChunk) {
                this.lastChunk = currentChunk;
                this.writer = this.buildWriter(this.lastChunk);
            }
        }

        protected abstract Writer buildWriter(long var1);
    }

    public static class AlwaysOutputPicker<T>
    implements OutputPicker<T> {
        private final T next;

        public AlwaysOutputPicker(T next) {
            this.next = next;
        }

        @Override
        public T output() {
            return this.next;
        }

        @Override
        public void entitiesMunged(int entitiesMunged) {
        }
    }

    public static interface OutputPicker<T> {
        public T output();

        public void entitiesMunged(int var1);
    }

    public static class Httpd
    extends NanoHTTPD {
        private final AtomicBoolean busy = new AtomicBoolean(false);
        private final BlockingQueue<InputStream> results;

        public Httpd(int port, BlockingQueue<InputStream> results) {
            super(port);
            this.results = results;
        }

        public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
            try {
                this.busy.set(true);
                NanoHTTPD.Response response = new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, " application/x-turtle", this.results.take()){

                    protected void send(OutputStream outputStream) {
                        super.send(outputStream);
                        Httpd.this.busy.set(false);
                    }
                };
                response.setChunkedTransfer(true);
                return response;
            }
            catch (InterruptedException e) {
                log.error("Interrupted while waiting for a result", (Throwable)e);
                Thread.currentThread().interrupt();
                this.busy.set(false);
                return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "internal server error");
            }
        }
    }

    private static class EntityMungingRdfHandler
    implements RDFHandler {
        private final WikibaseUris uris;
        private final Munger munger;
        private final OutputPicker<RDFHandler> next;
        private final List<Statement> statements = new ArrayList<Statement>();
        private final Meter entitiesMeter = new Meter();
        private boolean haveNonEntityDataStatements;
        private String entityId;

        public EntityMungingRdfHandler(WikibaseUris uris, Munger munger, OutputPicker<RDFHandler> next) {
            this.uris = uris;
            this.munger = munger;
            this.next = next;
        }

        public void startRDF() throws RDFHandlerException {
            this.haveNonEntityDataStatements = false;
            this.next.output().startRDF();
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            this.next.output().handleNamespace(prefix, uri);
        }

        public void handleComment(String comment) throws RDFHandlerException {
            this.next.output().handleComment(comment);
        }

        public void handleStatement(Statement statement) throws RDFHandlerException {
            String subject = statement.getSubject().stringValue();
            if (subject.startsWith(this.uris.entityDataHttps()) || subject.startsWith(this.uris.entityData())) {
                if (this.haveNonEntityDataStatements) {
                    this.munge();
                }
                if (statement.getPredicate().stringValue().equals("http://schema.org/about")) {
                    this.entityId = statement.getObject().stringValue();
                    this.entityId = this.entityId.substring(this.entityId.lastIndexOf(47) + 1);
                }
                this.statements.add(statement);
                return;
            }
            if (subject.equals("http://wikiba.se/ontology#Dump")) {
                this.next.output().handleStatement(statement);
                return;
            }
            if (statement.getPredicate().stringValue().equals("http://www.w3.org/2002/07/owl#sameAs")) {
                if (this.haveNonEntityDataStatements) {
                    this.munge();
                }
                this.entityId = subject.substring(subject.lastIndexOf(47) + 1);
                this.statements.add(statement);
                this.haveNonEntityDataStatements = true;
                return;
            }
            this.haveNonEntityDataStatements = true;
            this.statements.add(statement);
        }

        public void endRDF() throws RDFHandlerException {
            this.munge();
            this.next.output().endRDF();
        }

        private void munge() throws RDFHandlerException {
            try {
                log.debug("Munging {}", (Object)this.entityId);
                this.munger.munge(this.entityId, this.statements);
                for (Statement statement : this.statements) {
                    this.next.output().handleStatement(statement);
                }
                this.entitiesMeter.mark();
                if (this.entitiesMeter.getCount() % 10000L == 0L) {
                    log.info("Processed {} entities at ({}, {}, {})", new Object[]{this.entitiesMeter.getCount(), (long)this.entitiesMeter.getOneMinuteRate(), (long)this.entitiesMeter.getFiveMinuteRate(), (long)this.entitiesMeter.getFifteenMinuteRate()});
                }
                this.next.entitiesMunged((int)this.entitiesMeter.getCount());
            }
            catch (ContainedException e) {
                log.warn("Error munging {}", (Object)this.entityId, (Object)e);
            }
            this.statements.clear();
            this.haveNonEntityDataStatements = false;
        }
    }

    public static interface Options
    extends OptionsUtils.BasicOptions,
    OptionsUtils.MungerOptions,
    OptionsUtils.WikibaseOptions {
        @Option(shortName={"f"}, defaultValue={"-"}, description="Source file (or uri) to munge. Default is - aka stdin.")
        public String from();

        @Option(shortName={"t"}, defaultValue={"-"}, description="Destination of munge. Use port:<port_number> to start an http server on that port. Default is - aka stdout. If the file's parent directories don't exist then they will be created ala mkdir -p.")
        public String to();

        @Option(defaultValue={"0"}, description="Chunk size in entities. If specified then the \"to\" option must be a java format string containing a single format identifier which is replaced with the chunk number port:<port_numer>. %08d.ttl is a pretty good choice for format string. If \"to\" is in port form then every http request will get the next chunk. Must be greater than 0 and less than 2147483647.")
        public int chunkSize();
    }
}

