/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli.parser;

import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.parser.ArgumentParser;
import com.lexicalscope.jewel.cli.parser.ParsedArguments;

class ArgumentParserImpl
implements ArgumentParser {
    ArgumentParserImpl() {
    }

    @Override
    public void parseArguments(ParsedArguments parsedArguments, String ... arguments) throws ArgumentValidationException {
        boolean finishedOptions = false;
        for (String argument : arguments) {
            if (finishedOptions) {
                parsedArguments.addValue(argument);
                continue;
            }
            finishedOptions = this.add(parsedArguments, argument);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean add(ParsedArguments parsedArguments, String argument) throws ArgumentValidationException {
        if (!this.startsWithDash(argument)) {
            parsedArguments.addValue(argument);
            return false;
        }
        if (!this.startsWithDoubleDash(argument)) {
            this.addConjoinedOptions(parsedArguments, argument.substring(1));
            return false;
        }
        if (argument.length() > 2) {
            this.addOptionAndValue(parsedArguments, argument);
            return false;
        }
        parsedArguments.unparsedOptionsFollow();
        return true;
    }

    private void addConjoinedOptions(ParsedArguments parsedArguments, String options) throws ArgumentValidationException {
        for (int i = 0; i < options.length(); ++i) {
            parsedArguments.addOption(options.substring(i, i + 1));
        }
    }

    private void addOptionAndValue(ParsedArguments parsedArguments, String argument) throws ArgumentValidationException {
        if (argument.contains("=")) {
            int separatorIndex = argument.indexOf("=");
            parsedArguments.addOption(argument.substring(2, separatorIndex).trim());
            if (argument.length() > separatorIndex + 1) {
                parsedArguments.addValue(argument.substring(separatorIndex + 1).trim());
            }
        } else {
            parsedArguments.addOption(argument.substring(2, argument.length()).trim());
        }
    }

    private boolean startsWithDash(String argument) {
        return argument.length() > 1 && argument.startsWith("-");
    }

    private boolean startsWithDoubleDash(String argument) {
        return argument.startsWith("--");
    }
}

