/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.RetryableException;

public class IdListChangeSource
implements Change.Source<Batch> {
    private final int batchSize;
    private final String[] ids;

    public static IdListChangeSource forItems(String[] ids, int batchSize) {
        return new IdListChangeSource(ids, batchSize);
    }

    public IdListChangeSource(String[] ids, int batchSize) {
        this.batchSize = batchSize;
        this.ids = ids;
    }

    @Override
    public Batch firstBatch() throws RetryableException {
        return this.batch(0);
    }

    @Override
    public Batch nextBatch(Batch lastBatch) throws RetryableException {
        return this.batch(lastBatch.nextStart);
    }

    private Batch batch(int batchStart) {
        int batchStop = Math.min(batchStart + this.batchSize, this.ids.length);
        ImmutableList.Builder changes = ImmutableList.builder();
        for (int id = batchStart; id < batchStop; ++id) {
            changes.add(new Change(this.ids[id], -1L, null, id));
        }
        return new Batch((ImmutableList)changes.build(), batchStop - batchStart, batchStop);
    }

    public final class Batch
    extends Change.Batch.AbstractDefaultImplementation {
        private final int nextStart;

        private Batch(ImmutableList<Change> changes, long advanced, int nextStart) {
            super(changes, advanced, nextStart - 1);
            this.nextStart = nextStart;
        }

        @Override
        public String advancedUnits() {
            return "ids";
        }

        @Override
        public boolean last() {
            return this.nextStart >= IdListChangeSource.this.ids.length;
        }

        @Override
        public Date leftOffDate() {
            return null;
        }
    }
}

