/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.codahale.metrics.Meter;
import com.lexicalscope.jewel.cli.Option;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.turtle.TurtleParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.CliUtils;
import org.wikidata.query.rdf.tool.MungePart;
import org.wikidata.query.rdf.tool.OptionsUtils;
import org.wikidata.query.rdf.tool.StreamUtils;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.rdf.PrefixRecordingRdfHandler;

public class MungeLang
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MungePart.class);
    private final WikibaseUris uris;
    private final Reader from;
    private final OutputPicker<Writer> to;

    public static void main(String[] args) {
        OutputPicker<Writer> to;
        Options options = OptionsUtils.handleOptions(Options.class, args);
        WikibaseUris uris = new WikibaseUris(options.wikibaseHost());
        try {
            to = options.chunkSize() > 0 ? new ChunkedFileWriterOutputPicker(options.to(), options.chunkSize()) : new AlwaysOutputPicker<Writer>(CliUtils.writer(options.to()));
        }
        catch (IOException e) {
            log.error("Error finding output", (Throwable)e);
            System.exit(1);
            return;
        }
        try {
            MungeLang munge = new MungeLang(uris, MungeLang.openInput(options.from()), to);
            munge.run();
        }
        catch (RuntimeException e) {
            log.error("Fatal error munging RDF", (Throwable)e);
            System.exit(1);
        }
    }

    private static Reader openInput(String from) {
        try {
            return CliUtils.reader(from);
        }
        catch (IOException e) {
            log.error("Error finding input", (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    public MungeLang(WikibaseUris uris, Reader from, OutputPicker<Writer> to) {
        this.uris = uris;
        this.from = from;
        this.to = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ForbiddenOk.HackedTurtleParser parser = new ForbiddenOk.HackedTurtleParser();
            WriterToRDFWriterChunkPicker writer = new WriterToRDFWriterChunkPicker(this.to);
            EntityMungingRdfHandler handler = new EntityMungingRdfHandler(this.uris, writer);
            parser.setRDFHandler(handler);
            try {
                parser.parse(this.from, this.uris.entity());
            }
            catch (IOException | RDFHandlerException | RDFParseException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                this.from.close();
            }
            catch (IOException e) {
                log.error("Error closing input", (Throwable)e);
            }
            try {
                this.to.output().close();
            }
            catch (IOException e) {
                log.error("Error closing output", (Throwable)e);
            }
        }
    }

    private static class ForbiddenOk {
        private ForbiddenOk() {
        }

        private static class HackedTurtleParser
        extends TurtleParser {
            private HackedTurtleParser() {
            }

            protected URI parseURI() throws IOException, RDFParseException {
                try {
                    return super.parseURI();
                }
                catch (RDFParseException e) {
                    if (e.getMessage().startsWith("IRI includes string escapes: ") || e.getMessage().startsWith("IRI included an unencoded space: '32'")) {
                        log.warn("Attempting to recover from", (Throwable)e);
                        if (!e.getMessage().startsWith("IRI includes string escapes: '\\62'")) {
                            while (this.readCodePoint() != 62) {
                            }
                        }
                        return super.resolveURI("http://example.com/error");
                    }
                    throw e;
                }
            }

            protected void parseStatement() throws IOException, RDFParseException, RDFHandlerException {
                try {
                    super.parseStatement();
                }
                catch (RDFParseException e) {
                    log.warn("Exception after statement: {} {}", (Object)((EntityMungingRdfHandler)this.rdfHandler).getLast(), (Object)e);
                    while (this.readCodePoint() != 10) {
                    }
                }
            }
        }
    }

    private static class WriterToRDFWriterChunkPicker
    implements OutputPicker<RDFHandler> {
        private final Map<String, String> prefixes = new LinkedHashMap<String, String>();
        private final OutputPicker<Writer> next;
        private Writer lastWriter;
        private RDFHandler handler;

        public WriterToRDFWriterChunkPicker(OutputPicker<Writer> next) {
            this.next = next;
            this.lastWriter = next.output();
            try {
                this.setHandlerFromLastWriter();
            }
            catch (RDFHandlerException e) {
                throw new RuntimeException("Error setting up first rdf writer", e);
            }
        }

        @Override
        public RDFHandler output() {
            Writer nextWriter = this.next.output();
            if (nextWriter == this.lastWriter) {
                return this.handler;
            }
            try {
                this.handler.endRDF();
                this.lastWriter.close();
                this.lastWriter = nextWriter;
                this.setHandlerFromLastWriter();
                this.handler.startRDF();
            }
            catch (IOException | RDFHandlerException e) {
                throw new RuntimeException("Error switching chunks", e);
            }
            return this.handler;
        }

        @Override
        public void entitiesMunged(int entitiesMunged) {
            this.next.entitiesMunged(entitiesMunged);
        }

        private void setHandlerFromLastWriter() throws RDFHandlerException {
            RDFWriter writer = Rio.createWriter((RDFFormat)RDFFormat.TURTLE, (Writer)this.lastWriter);
            WriterConfig config = writer.getWriterConfig();
            config.set(BasicWriterSettings.PRETTY_PRINT, (Object)false);
            this.handler = new PrefixRecordingRdfHandler((RDFHandler)writer, this.prefixes);
            for (Map.Entry<String, String> prefix : this.prefixes.entrySet()) {
                this.handler.handleNamespace(prefix.getKey(), prefix.getValue());
            }
        }
    }

    public static class ChunkedPipedWriterOutputPicker
    extends ChunkedWriterOutputPicker {
        private final BlockingQueue<InputStream> queue;

        public ChunkedPipedWriterOutputPicker(BlockingQueue<InputStream> queue, int chunkSize) {
            super(chunkSize);
            this.queue = queue;
        }

        @Override
        protected Writer buildWriter(long chunk) {
            PipedInputStream toQueue = new PipedInputStream();
            try {
                this.queue.put(toQueue);
                return StreamUtils.utf8(new PipedOutputStream(toQueue));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Error switching chunks", e);
            }
        }
    }

    public static class ChunkedFileWriterOutputPicker
    extends ChunkedWriterOutputPicker {
        private final String pattern;

        public ChunkedFileWriterOutputPicker(String pattern, int chunkSize) {
            super(chunkSize);
            this.pattern = pattern;
        }

        @Override
        protected Writer buildWriter(long chunk) {
            String file = String.format(Locale.ROOT, this.pattern, chunk);
            log.info("Switching to {}", (Object)file);
            try {
                return CliUtils.writer(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Error switching chunks", e);
            }
        }
    }

    private static abstract class ChunkedWriterOutputPicker
    implements OutputPicker<Writer> {
        private final int chunkSize;
        private Writer writer;
        private int lastChunk = 1;

        public ChunkedWriterOutputPicker(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        public Writer output() {
            if (this.writer == null) {
                this.writer = this.buildWriter(this.lastChunk);
            }
            return this.writer;
        }

        @Override
        public void entitiesMunged(int entitiesMunged) {
            int currentChunk = entitiesMunged / this.chunkSize + 1;
            if (this.lastChunk != currentChunk) {
                this.lastChunk = currentChunk;
                this.writer = this.buildWriter(this.lastChunk);
            }
        }

        protected abstract Writer buildWriter(long var1);
    }

    public static class AlwaysOutputPicker<T>
    implements OutputPicker<T> {
        private final T next;

        public AlwaysOutputPicker(T next) {
            this.next = next;
        }

        @Override
        public T output() {
            return this.next;
        }

        @Override
        public void entitiesMunged(int entitiesMunged) {
        }
    }

    public static interface OutputPicker<T> {
        public T output();

        public void entitiesMunged(int var1);
    }

    private static class EntityMungingRdfHandler
    implements RDFHandler {
        private final WikibaseUris uris;
        private final OutputPicker<RDFHandler> next;
        private final List<Statement> statements = new ArrayList<Statement>();
        private final Meter entitiesMeter = new Meter();
        private String entityId;
        private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^[a-z0-9-]+$");
        private Statement lastStatement;

        public EntityMungingRdfHandler(WikibaseUris uris, OutputPicker<RDFHandler> next) {
            this.uris = uris;
            this.next = next;
        }

        public void startRDF() throws RDFHandlerException {
            this.next.output().startRDF();
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            this.next.output().handleNamespace(prefix, uri);
        }

        public void handleComment(String comment) throws RDFHandlerException {
            this.next.output().handleComment(comment);
        }

        public Statement getLast() {
            return this.lastStatement;
        }

        public void handleStatement(Statement statement) throws RDFHandlerException {
            Matcher m;
            String language;
            this.lastStatement = statement;
            Value object = statement.getObject();
            if (object instanceof Literal && (language = ((Literal)object).getLanguage()) != null && !(m = LANGUAGE_PATTERN.matcher(language)).matches()) {
                this.statements.add(statement);
                this.munge();
            }
        }

        public void endRDF() throws RDFHandlerException {
            this.munge();
            this.next.output().endRDF();
        }

        private void munge() throws RDFHandlerException {
            try {
                for (Statement statement : this.statements) {
                    this.next.output().handleStatement(statement);
                }
                this.entitiesMeter.mark();
                if (this.entitiesMeter.getCount() % 10000L == 0L) {
                    log.info("Processed {} entities at ({}, {}, {})", new Object[]{this.entitiesMeter.getCount(), (long)this.entitiesMeter.getOneMinuteRate(), (long)this.entitiesMeter.getFiveMinuteRate(), (long)this.entitiesMeter.getFifteenMinuteRate()});
                }
                this.next.entitiesMunged((int)this.entitiesMeter.getCount());
            }
            catch (ContainedException e) {
                log.warn("Error munging {}", (Object)this.entityId, (Object)e);
            }
            this.statements.clear();
        }
    }

    public static interface Options
    extends OptionsUtils.BasicOptions,
    OptionsUtils.WikibaseOptions {
        @Option(shortName={"f"}, defaultValue={"-"}, description="Source file (or uri) to munge. Default is - aka stdin.")
        public String from();

        @Option(shortName={"t"}, defaultValue={"-"}, description="Destination of munge. Use port:<port_number> to start an http server on that port. Default is - aka stdout. If the file's parent directories don't exist then they will be created ala mkdir -p.")
        public String to();

        @Option(defaultValue={"0"}, description="Chunk size in entities. If specified then the \"to\" option must be a java format string containing a single format identifier which is replaced with the chunk number port:<port_numer>. %08d.ttl is a pretty good choice for format string. If \"to\" is in port form then every http request will get the next chunk. Must be greater than 0 and less than 2147483647.")
        public int chunkSize();
    }
}

