/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.collect.ImmutableList;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public class RecentChangesPoller
implements Change.Source<Batch> {
    private static final Logger log = LoggerFactory.getLogger(RecentChangesPoller.class);
    private final WikibaseRepository wikibase;
    private final Date firstStartTime;
    private final int batchSize;

    public RecentChangesPoller(WikibaseRepository wikibase, Date firstStartTime, int batchSize) {
        this.wikibase = wikibase;
        this.firstStartTime = firstStartTime;
        this.batchSize = batchSize;
    }

    @Override
    public Batch firstBatch() throws RetryableException {
        return this.batch(this.firstStartTime, null);
    }

    @Override
    public Batch nextBatch(Batch lastBatch) throws RetryableException {
        return this.batch(lastBatch.leftOffDate, lastBatch.nextContinue);
    }

    private Batch batch(Date lastNextStartTime, JSONObject lastNextContinue) throws RetryableException {
        try {
            Change continueChange = this.wikibase.getChangeFromContinue((Map<String, Object>)lastNextContinue);
            JSONObject recentChanges = this.wikibase.fetchRecentChangesBackoff(lastNextStartTime, this.batchSize, true);
            LinkedHashMap<String, Change> changesByTitle = new LinkedHashMap<String, Change>();
            JSONObject nextContinue = (JSONObject)recentChanges.get((Object)"continue");
            long nextStartTime = lastNextStartTime.getTime();
            JSONArray result = (JSONArray)((JSONObject)recentChanges.get((Object)"query")).get((Object)"recentchanges");
            DateFormat df = WikibaseRepository.inputDateFormat();
            for (Object rco : result) {
                JSONObject rc = (JSONObject)rco;
                long namespace = (Long)rc.get((Object)"ns");
                long rcid = (Long)rc.get((Object)"rcid");
                if (!this.wikibase.isEntityNamespace(namespace)) {
                    log.info("Skipping change in irrelevant namespace:  {}", (Object)rc);
                    continue;
                }
                if (!this.wikibase.isValidEntity(rc.get((Object)"title").toString())) {
                    log.info("Skipping change with bogus id:  {}", (Object)rc.get((Object)"title").toString());
                    continue;
                }
                Date timestamp = df.parse(rc.get((Object)"timestamp").toString());
                Change change = rc.get((Object)"type").toString().equals("log") && (Long)rc.get((Object)"revid") == 0L ? new Change(rc.get((Object)"title").toString(), -1L, timestamp, rcid) : new Change(rc.get((Object)"title").toString(), (Long)rc.get((Object)"revid"), timestamp, (Long)rc.get((Object)"rcid"));
                Change dupe = changesByTitle.put(change.entityId(), change);
                if (dupe != null && (dupe.revision() > change.revision() || dupe.revision() < 0L)) {
                    changesByTitle.remove(change.entityId());
                    changesByTitle.put(change.entityId(), dupe);
                }
                nextStartTime = Math.max(nextStartTime, timestamp.getTime());
            }
            ImmutableList changes = ImmutableList.copyOf(changesByTitle.values());
            if (nextContinue == null) {
                if (changes.size() != 0) {
                    nextContinue = this.wikibase.getContinueObject((Change)changes.get(changes.size() - 1));
                } else {
                    if (result.size() >= this.batchSize) {
                        log.info("Backoff overflow, advancing one second");
                        nextStartTime += 1000L;
                    }
                    nextContinue = lastNextContinue;
                }
            }
            if (changes.size() != 0) {
                log.info("Got {} changes, from {} to {}", new Object[]{changes.size(), ((Change)changes.get(0)).toString(), ((Change)changes.get(changes.size() - 1)).toString()});
            } else {
                log.info("Got no real changes");
            }
            String upTo = WikibaseRepository.inputDateFormat().format(new Date(nextStartTime - 1000L));
            long advanced = nextStartTime - lastNextStartTime.getTime();
            return new Batch(changes, advanced, upTo, new Date(nextStartTime), nextContinue);
        }
        catch (ParseException e) {
            throw new RetryableException("Parse error from api", e);
        }
    }

    public final class Batch
    extends Change.Batch.AbstractDefaultImplementation {
        private final Date leftOffDate;
        private final JSONObject nextContinue;

        private Batch(ImmutableList<Change> changes, long advanced, String leftOff, Date nextStartTime, JSONObject nextContinue) {
            super(changes, advanced, leftOff);
            this.leftOffDate = nextStartTime;
            this.nextContinue = nextContinue;
        }

        @Override
        public String advancedUnits() {
            return "milliseconds";
        }

        @Override
        public Date leftOffDate() {
            return this.leftOffDate;
        }

        @Override
        public String leftOffHuman() {
            return this.leftOffDate.toString() + " (next: " + this.nextContinue.get((Object)"rccontinue").toString() + ")";
        }
    }
}

