/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.wikibase;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.HttpClientUtils;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.rdf.NormalizingRdfHandler;

public class WikibaseRepository {
    private static final Logger log = LoggerFactory.getLogger(WikibaseRepository.class);
    private static final int RETRIES = 3;
    private final CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(100).setMaxConnTotal(100).setRetryHandler(WikibaseRepository.getRetryHandler(3)).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new DefaultServiceUnavailableRetryStrategy(3, 500)).setUserAgent("Wikidata Query Service Updater").build();
    private final Uris uris;
    private static final int BACKOFF_TIME = 10;

    public WikibaseRepository(String scheme, String host) {
        this.uris = new Uris(scheme, host);
    }

    public WikibaseRepository(String scheme, String host, int port) {
        this.uris = new Uris(scheme, host, port);
    }

    public WikibaseRepository(String scheme, String host, int port, long[] entityNamespaces) {
        this.uris = new Uris(scheme, host, port, entityNamespaces);
    }

    public static HttpRequestRetryHandler getRetryHandler(final int max) {
        HttpRequestRetryHandler myRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean idempotent;
                log.debug("Exception: {} in attempt {}", (Object)exception, (Object)executionCount);
                if (executionCount >= max) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return true;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        return myRetryHandler;
    }

    private Date backoffTime(Date startTime) {
        if (startTime.before(DateUtils.addMinutes((Date)new Date(), (int)-5))) {
            return DateUtils.addSeconds((Date)startTime, (int)-1);
        }
        return DateUtils.addSeconds((Date)startTime, (int)-10);
    }

    public JSONObject fetchRecentChangesBackoff(Date nextStartTime, int batchSize, boolean useBackoff) throws RetryableException {
        if (useBackoff) {
            return this.fetchRecentChanges(this.backoffTime(nextStartTime), batchSize);
        }
        return this.fetchRecentChanges(nextStartTime, batchSize);
    }

    public JSONObject fetchRecentChanges(Date nextStartTime, int batchSize) throws RetryableException {
        URI uri = this.uris.recentChanges(nextStartTime, batchSize);
        log.debug("Polling for changes from {}", (Object)uri);
        try {
            return this.checkApi(this.getJson((HttpRequestBase)new HttpGet(uri)));
        }
        catch (SocketException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error fetching recent changes", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Statement> fetchRdfForEntity(String entityId) throws RetryableException {
        URI uri = this.uris.rdf(entityId);
        long start = System.currentTimeMillis();
        log.debug("Fetching rdf from {}", (Object)uri);
        RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
        StatementCollector collector = new StatementCollector();
        parser.setRDFHandler((RDFHandler)new NormalizingRdfHandler((RDFHandler)collector));
        HttpGet request = new HttpGet(uri);
        HttpClientUtils.ignoreCookies((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() == 404) {
                List<Statement> list = Collections.emptyList();
                return list;
            }
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new ContainedException("Unexpected status code fetching RDF for " + uri + ":  " + response.getStatusLine().getStatusCode());
            }
            parser.parse((Reader)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8), uri.toString());
        }
        catch (SocketException | UnknownHostException | SSLHandshakeException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RetryableException("Error fetching RDF for " + uri, e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new ContainedException("RDF parsing error for " + uri, e);
        }
        log.debug("Done in {} ms", (Object)(System.currentTimeMillis() - start));
        return collector.getStatements();
    }

    public String firstEntityIdForLabelStartingWith(String label, String language, String type) throws RetryableException {
        URI uri = this.uris.searchForLabel(label, language, type);
        log.debug("Searching for entity using {}", (Object)uri);
        try {
            JSONObject result = this.checkApi(this.getJson((HttpRequestBase)new HttpGet(uri)));
            JSONArray resultList = (JSONArray)result.get((Object)"search");
            if (resultList.isEmpty()) {
                return null;
            }
            result = (JSONObject)resultList.get(0);
            return result.get((Object)"id").toString();
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error searching for page", e);
        }
    }

    public String setLabel(String entityId, String type, String label, String language) throws RetryableException {
        JSONObject data = new JSONObject();
        JSONObject labels = new JSONObject();
        data.put((Object)"labels", (Object)labels);
        JSONObject labelObject = new JSONObject();
        labels.put((Object)"en", (Object)labelObject);
        labelObject.put((Object)"language", (Object)language);
        labelObject.put((Object)"value", (Object)(label + System.currentTimeMillis()));
        if (type.equals("property")) {
            data.put((Object)"datatype", (Object)"string");
        }
        URI uri = this.uris.edit(entityId, type, data.toJSONString());
        log.debug("Editing entity using {}", (Object)uri);
        try {
            JSONObject result = this.checkApi(this.getJson((HttpRequestBase)this.postWithToken(uri)));
            return ((JSONObject)result.get((Object)"entity")).get((Object)"id").toString();
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error adding page", e);
        }
    }

    public void delete(String entityId) throws RetryableException {
        URI uri = this.uris.delete(entityId);
        log.debug("Deleting entity {} using {}", (Object)entityId, (Object)uri);
        try {
            JSONObject result = this.checkApi(this.getJson((HttpRequestBase)this.postWithToken(uri)));
            log.debug("Deleted: {}", (Object)result);
        }
        catch (IOException | ParseException e) {
            throw new RetryableException("Error deleting page", e);
        }
    }

    private HttpPost postWithToken(URI uri) throws IOException, ParseException {
        HttpPost request = new HttpPost(uri);
        ArrayList<BasicNameValuePair> entity = new ArrayList<BasicNameValuePair>();
        entity.add(new BasicNameValuePair("token", this.csrfToken()));
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(entity, Consts.UTF_8));
        return request;
    }

    private String csrfToken() throws IOException, ParseException {
        URI uri = this.uris.csrfToken();
        log.debug("Fetching csrf token from {}", (Object)uri);
        return ((JSONObject)((JSONObject)this.getJson((HttpRequestBase)new HttpGet(uri)).get((Object)"query")).get((Object)"tokens")).get((Object)"csrftoken").toString();
    }

    private JSONObject getJson(HttpRequestBase request) throws IOException, ParseException {
        HttpClientUtils.ignoreCookies(request);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            JSONObject jSONObject = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8));
            return jSONObject;
        }
    }

    private JSONObject checkApi(JSONObject response) throws RetryableException {
        Object error = response.get((Object)"error");
        if (error != null) {
            throw new RetryableException("Error result from Mediawiki:  " + error);
        }
        return response;
    }

    public boolean isEntityNamespace(long namespace) {
        return ArrayUtils.contains((long[])this.uris.getEntityNamespaces(), (long)namespace);
    }

    public boolean isValidEntity(String name) {
        return name.matches("^[A-Za-z0-9:]+$");
    }

    public static DateFormat outputDateFormat() {
        return WikibaseRepository.utc(new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT));
    }

    public static DateFormat inputDateFormat() {
        return WikibaseRepository.utc(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT));
    }

    private static DateFormat utc(DateFormat df) {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    public JSONObject getContinueObject(Change lastChange) {
        JSONObject nextContinue = new JSONObject();
        nextContinue.put((Object)"rccontinue", (Object)(WikibaseRepository.outputDateFormat().format(lastChange.timestamp()) + "|" + (lastChange.rcid() + 1L)));
        nextContinue.put((Object)"continue", (Object)"-||");
        return nextContinue;
    }

    public Change getChangeFromContinue(Map<String, Object> nextContinue) throws java.text.ParseException {
        if (nextContinue == null) {
            return null;
        }
        String rccontinue = (String)nextContinue.get("rccontinue");
        String[] parts = rccontinue.split("\\|");
        return new Change("DUMMY", -1L, WikibaseRepository.outputDateFormat().parse(parts[0]), Long.parseLong(parts[1]));
    }

    public static class Uris {
        private final String scheme;
        private final String host;
        private final int port;
        private long[] entityNamespaces = new long[]{0L, 120L};

        public Uris(String scheme, String host) {
            this.scheme = scheme;
            this.host = host;
            this.port = 0;
        }

        public Uris(String scheme, String host, int port) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
        }

        public Uris(String scheme, String host, int port, long[] entityNamespaces) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.entityNamespaces = entityNamespaces;
        }

        public URI recentChanges(Date startTime, int batchSize) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "query");
            builder.addParameter("list", "recentchanges");
            builder.addParameter("rcdir", "newer");
            builder.addParameter("rcprop", "title|ids|timestamp");
            builder.addParameter("rcnamespace", this.getEntityNamespacesString("|"));
            builder.addParameter("rclimit", Integer.toString(batchSize));
            builder.addParameter("continue", "");
            builder.addParameter("rcstart", WikibaseRepository.outputDateFormat().format(startTime));
            return this.build(builder);
        }

        public URI rdf(String entityId) {
            URIBuilder builder = this.builder();
            builder.setPath(String.format(Locale.ROOT, "/wiki/Special:EntityData/%s.ttl", entityId));
            builder.addParameter("nocache", Long.toString(new Date().getTime()));
            builder.addParameter("flavor", "dump");
            return this.build(builder);
        }

        public URI csrfToken() {
            URIBuilder builder = this.apiBuilder();
            builder.setParameter("action", "query");
            builder.setParameter("meta", "tokens");
            builder.setParameter("continue", "");
            return this.build(builder);
        }

        public URI searchForLabel(String label, String language, String type) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "wbsearchentities");
            builder.addParameter("search", label);
            builder.addParameter("language", language);
            builder.addParameter("type", type);
            return this.build(builder);
        }

        public URI edit(String entityId, String newType, String data) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "wbeditentity");
            if (entityId != null) {
                builder.addParameter("id", entityId);
            } else {
                builder.addParameter("new", newType);
            }
            builder.addParameter("data", data);
            return this.build(builder);
        }

        public URI delete(String entityId) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "delete");
            builder.addParameter("title", entityId);
            return this.build(builder);
        }

        private URIBuilder apiBuilder() {
            URIBuilder builder = this.builder();
            builder.setPath("/w/api.php");
            builder.addParameter("format", "json");
            return builder;
        }

        public URIBuilder builder() {
            URIBuilder builder = new URIBuilder();
            builder.setHost(this.host);
            builder.setScheme(this.scheme);
            if (this.port != 0) {
                builder.setPort(this.port);
            }
            return builder;
        }

        private URI build(URIBuilder builder) {
            try {
                return builder.build();
            }
            catch (URISyntaxException e) {
                throw new FatalException("Unable to build url!?", e);
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getScheme() {
            return this.scheme;
        }

        private long[] getEntityNamespaces() {
            return this.entityNamespaces;
        }

        private String getEntityNamespacesString(String delimiter) {
            String rcnamespace = "";
            for (long i : this.entityNamespaces) {
                rcnamespace = rcnamespace + i + delimiter;
            }
            return rcnamespace.substring(0, rcnamespace.length() - delimiter.length());
        }
    }
}

