/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.logstash.logback.encoder.com.lmax.disruptor.BlockingWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.BusySpinWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.LiteBlockingWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.PhasedBackoffWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.SleepingWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.WaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.YieldingWaitStrategy;

public class WaitStrategyFactory {
    private static final char PARAM_END_CHAR = '}';
    private static final char PARAM_START_CHAR = '{';
    private static final char PARAM_SEPARATOR_CHAR = ',';

    public static WaitStrategy createWaitStrategyFromString(String waitStrategyType) {
        if (waitStrategyType == null) {
            return null;
        }
        if ((waitStrategyType = waitStrategyType.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        if (waitStrategyType.equals("blocking")) {
            return new BlockingWaitStrategy();
        }
        if (waitStrategyType.equals("busyspin")) {
            return new BusySpinWaitStrategy();
        }
        if (waitStrategyType.equals("liteblocking")) {
            return new LiteBlockingWaitStrategy();
        }
        if (waitStrategyType.equals("sleeping")) {
            return new SleepingWaitStrategy();
        }
        if (waitStrategyType.equals("yielding")) {
            return new YieldingWaitStrategy();
        }
        if (waitStrategyType.startsWith("phasedbackoff")) {
            List<Object> params = WaitStrategyFactory.parseParams(waitStrategyType, Long.class, Long.class, TimeUnit.class, WaitStrategy.class);
            return new PhasedBackoffWaitStrategy((Long)params.get(0), (Long)params.get(1), (TimeUnit)((Object)params.get(2)), (WaitStrategy)params.get(3));
        }
        if (waitStrategyType.startsWith("timeoutblocking")) {
            List<Object> params = WaitStrategyFactory.parseParams(waitStrategyType, Long.class, TimeUnit.class);
            return new TimeoutBlockingWaitStrategy((Long)params.get(0), (TimeUnit)((Object)params.get(1)));
        }
        throw new IllegalArgumentException("Unknown wait strategy type: " + waitStrategyType);
    }

    private static List<Object> parseParams(String waitStrategyType, Class<?> ... paramTypes) {
        String paramsString = WaitStrategyFactory.extractParamsString(waitStrategyType, paramTypes);
        ArrayList<Object> params = new ArrayList<Object>(paramTypes.length);
        int startIndex = 0;
        for (int i = 0; i < paramTypes.length && startIndex < paramsString.length(); ++i) {
            int endIndex = WaitStrategyFactory.findParamEndIndex(paramsString, startIndex);
            String paramString = paramsString.substring(startIndex, endIndex).trim();
            startIndex = endIndex + 1;
            if (Long.class.equals(paramTypes[i])) {
                params.add(Long.valueOf(paramString));
                continue;
            }
            if (TimeUnit.class.equals(paramTypes[i])) {
                params.add((Object)TimeUnit.valueOf(paramString.toUpperCase()));
                continue;
            }
            if (WaitStrategy.class.equals(paramTypes[i])) {
                params.add(WaitStrategyFactory.createWaitStrategyFromString(paramString));
                continue;
            }
            throw new IllegalArgumentException("Unknown paramType " + paramTypes[i]);
        }
        if (params.size() != paramTypes.length) {
            throw new IllegalArgumentException(String.format("%d parameters must be provided for waitStrategyType %s. %d were provided.", paramTypes.length, waitStrategyType, params.size()));
        }
        return params;
    }

    private static String extractParamsString(String waitStrategyType, Class<?> ... paramTypes) {
        int startIndex = waitStrategyType.indexOf(123);
        if (startIndex == -1) {
            throw new IllegalArgumentException(String.format("%d parameters must be provided for waitStrategyType %s. None were provided. To provide parameters, add a comma separated value list within curly braces ({}) to the end of the waitStrategyType string.", paramTypes.length, waitStrategyType));
        }
        int endIndex = waitStrategyType.lastIndexOf(125);
        if (endIndex == -1) {
            throw new IllegalArgumentException(String.format("Parameters of %s must end with '}'", waitStrategyType));
        }
        return waitStrategyType.substring(startIndex + 1, endIndex);
    }

    private static int findParamEndIndex(String paramsString, int startIndex) {
        int nestLevel = 0;
        for (int c = startIndex; c < paramsString.length(); ++c) {
            char character = paramsString.charAt(c);
            if (character == '{') {
                ++nestLevel;
                continue;
            }
            if (character == '}') {
                if (--nestLevel >= 0) continue;
                throw new IllegalArgumentException(String.format("Unbalanced '}' at character position %d in %s", c, paramsString));
            }
            if (character != ',' || nestLevel != 0) continue;
            return c;
        }
        if (nestLevel != 0) {
            throw new IllegalArgumentException(String.format("Unbalanced '{' in %s", paramsString));
        }
        return paramsString.length();
    }
}

