/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.common.uri;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL"}, justification="keeping `rootHttps` as an instance variable to be coherent with other fields")
public class WikibaseUris {
    public static final WikibaseUris WIKIDATA = new WikibaseUris("www.wikidata.org");
    public static final String WIKIBASE_HOST_PROPERTY = "wikibaseHost";
    private static WikibaseUris uriSystem;
    private final String root;
    private final String rootHttps;
    private final String entityData;
    private final String entityDataHttps;
    private final String entity;
    private final String statement;
    private final String value;
    private final String reference;
    private final String prop;

    public WikibaseUris(String host) {
        this.root = "http://" + host;
        this.rootHttps = "https://" + host;
        this.entityData = this.root + "/wiki/Special:EntityData/";
        this.entityDataHttps = this.rootHttps + "/wiki/Special:EntityData/";
        this.entity = this.root + "/entity/";
        this.statement = this.entity + "statement/";
        this.value = this.root + "/value/";
        this.reference = this.root + "/reference/";
        this.prop = this.root + "/prop/";
    }

    @SuppressFBWarnings(value={"CBX_CUSTOM_BUILT_XML"}, justification="false positive - not actually XML")
    public StringBuilder prefixes(StringBuilder query) {
        query.append("PREFIX wdata: <").append(this.entityData).append(">\n");
        query.append("PREFIX wd: <").append(this.entity).append(">\n");
        query.append("PREFIX wds: <").append(this.statement).append(">\n");
        query.append("PREFIX wdv: <").append(this.value).append(">\n");
        query.append("PREFIX wdref: <").append(this.reference).append(">\n");
        for (PropertyType p : PropertyType.values()) {
            query.append("PREFIX ").append(p.prefix()).append(": <").append(this.prop).append(p.suffix()).append(">\n");
        }
        return query;
    }

    public String root() {
        return this.root;
    }

    public String entityData() {
        return this.entityData;
    }

    public String entityDataHttps() {
        return this.entityDataHttps;
    }

    public String entity() {
        return this.entity;
    }

    public String statement() {
        return this.statement;
    }

    public String value() {
        return this.value;
    }

    public String reference() {
        return this.reference;
    }

    public String property(PropertyType p) {
        return this.prop + p.suffix();
    }

    public static WikibaseUris getURISystem() {
        if (uriSystem == null) {
            String wikibaseHostProperty = System.getProperty(WIKIBASE_HOST_PROPERTY);
            uriSystem = wikibaseHostProperty != null ? new WikibaseUris(wikibaseHostProperty) : WIKIDATA;
        }
        return uriSystem;
    }

    public static enum PropertyType {
        DIRECT("wdt", "direct/"),
        STATEMENT_VALUE("psv", "statement/value/"),
        STATEMENT("ps", "statement/"),
        QUALIFIER_VALUE("pqv", "qualifier/value/"),
        QUALIFIER("pq", "qualifier/"),
        REFERENCE_VALUE("prv", "reference/value/"),
        REFERENCE("pr", "reference/"),
        NOVALUE("wdno", "novalue/"),
        CLAIM("p", "");

        private final String prefix;
        private final String suffix;

        private PropertyType(String p, String s) {
            this.prefix = p;
            this.suffix = s;
        }

        public String prefix() {
            return this.prefix;
        }

        protected String suffix() {
            return this.suffix;
        }
    }
}

