/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openrdf.model.Statement;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public class Change
implements Comparable<Change> {
    private final String entityId;
    private final long revision;
    private final Date timestamp;
    private Collection<Statement> statements;
    private Collection<String> cleanupList;
    private final long rcid;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="TODO: move to LocalDateTime")
    public Change(String entityId, long revision, Date timestamp, long rcid) {
        this.entityId = entityId.startsWith("Property:") ? entityId.substring("Property:".length()) : (entityId.startsWith("Item:") ? entityId.substring("Item:".length()) : entityId);
        this.revision = revision;
        this.timestamp = timestamp;
        this.rcid = rcid;
    }

    public String entityId() {
        return this.entityId;
    }

    public long revision() {
        return this.revision;
    }

    public long rcid() {
        return this.rcid;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="TODO: move to LocalDateTime")
    public Date timestamp() {
        return this.timestamp;
    }

    public String toString() {
        if (this.revision < -1L && this.timestamp == null) {
            return this.entityId;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.entityId);
        if (this.revision >= 0L) {
            b.append('@').append(this.revision);
        }
        if (this.timestamp != null) {
            b.append('@').append(WikibaseRepository.outputDateFormat().format(this.timestamp));
            b.append('|').append(this.rcid);
        }
        return b.toString();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="This looks suspicious, but would need more investigation")
    public int compareTo(Change o) {
        return (int)(this.rcid() - o.rcid());
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(Collection<Statement> statements) {
        this.statements = statements;
    }

    public Collection<String> getCleanupList() {
        return this.cleanupList;
    }

    public void setCleanupList(Collection<String> cleanupList) {
        this.cleanupList = cleanupList;
    }

    public static interface Batch {
        public List<Change> changes();

        public boolean hasAnyChanges();

        public String advancedUnits();

        public long advanced();

        public String leftOffHuman();

        public Date leftOffDate();

        public boolean last();

        public static abstract class AbstractDefaultImplementation
        implements Batch {
            private final ImmutableList<Change> changes;
            private final long advanced;
            private final Object leftOff;

            public AbstractDefaultImplementation(ImmutableList<Change> changes, long advanced, Object leftOff) {
                this.changes = Preconditions.checkNotNull(changes);
                this.advanced = advanced;
                this.leftOff = leftOff;
            }

            @Override
            public List<Change> changes() {
                return this.changes;
            }

            @Override
            public boolean hasAnyChanges() {
                return !this.changes.isEmpty();
            }

            @Override
            public long advanced() {
                return this.advanced;
            }

            @Override
            public String leftOffHuman() {
                return this.leftOff.toString();
            }

            @Override
            public boolean last() {
                return false;
            }
        }
    }

    public static interface Source<B extends Batch> {
        public B firstBatch() throws RetryableException;

        public B nextBatch(B var1) throws RetryableException;
    }
}

