/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import java.util.Collection;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class UpdateBuilder {
    private String update;

    public UpdateBuilder(String template) {
        this.update = template;
    }

    public UpdateBuilder bind(String from, String to) {
        this.update = this.update.replace('%' + from + '%', to);
        return this;
    }

    public UpdateBuilder bindValue(String from, Object to) {
        this.update = this.update.replace('%' + from + '%', this.str(to));
        return this;
    }

    public UpdateBuilder bindUri(String from, String to) {
        this.bind(from, '<' + to + '>');
        return this;
    }

    public UpdateBuilder bindStatements(String from, Collection<Statement> statements) {
        StringBuilder b = new StringBuilder(statements.size() * 30);
        for (Statement s : statements) {
            b.append(this.str(s.getSubject())).append(' ');
            b.append(this.str(s.getPredicate())).append(' ');
            b.append(this.str(s.getObject())).append(" .\n");
        }
        this.bind(from, b.toString().trim());
        return this;
    }

    public UpdateBuilder bindValues(String from, Collection<Statement> statements) {
        StringBuilder b = new StringBuilder(statements.size() * 30);
        for (Statement s : statements) {
            if (s.getObject() instanceof BNode || s.getSubject() instanceof BNode) continue;
            b.append("( ").append(this.str(s.getSubject())).append(' ');
            b.append(this.str(s.getPredicate())).append(' ');
            b.append(this.str(s.getObject())).append(" )\n");
        }
        this.bind(from, b.toString().trim());
        return this;
    }

    public UpdateBuilder bindUris(String from, Collection<String> uris) {
        return this.bindUris(from, uris, "");
    }

    public UpdateBuilder bindUris(String from, Collection<String> uris, String prefix) {
        StringBuilder b = new StringBuilder(uris.size() * 80);
        for (String s : uris) {
            b.append('<').append(prefix).append(s).append("> ");
        }
        this.bind(from, b.toString().trim());
        return this;
    }

    public String toString() {
        return this.update;
    }

    private String str(Object o) {
        if (o instanceof String) {
            return o.toString().replace("\"", "\\\"");
        }
        if (o instanceof URI) {
            return '<' + o.toString() + '>';
        }
        if (o instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)o;
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            sb.append(c.toXMLFormat());
            sb.append("\"^^<xsd:dateTime>");
            return sb.toString();
        }
        if (o instanceof Literal) {
            Literal l = (Literal)o;
            StringBuilder sb = new StringBuilder(l.getLabel().length() * 2);
            sb.append('\"');
            sb.append(l.getLabel().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n"));
            sb.append('\"');
            if (l.getLanguage() != null) {
                sb.append('@');
                sb.append(l.getLanguage());
            } else if (!l.getDatatype().equals(XMLSchema.STRING)) {
                sb.append("^^<");
                sb.append(l.getDatatype());
                sb.append('>');
            }
            return sb.toString();
        }
        if (o instanceof BNode) {
            return "_:" + ((BNode)o).getID();
        }
        throw new RuntimeException("I have no idea what do to with a " + o.getClass());
    }
}

