/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.common.uri.WikibaseUris;
import org.wikidata.query.rdf.tool.Updater;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.change.IdListChangeSource;
import org.wikidata.query.rdf.tool.change.IdRangeChangeSource;
import org.wikidata.query.rdf.tool.change.RecentChangesPoller;
import org.wikidata.query.rdf.tool.options.OptionsUtils;
import org.wikidata.query.rdf.tool.options.UpdateOptions;
import org.wikidata.query.rdf.tool.rdf.Munger;
import org.wikidata.query.rdf.tool.rdf.RdfRepository;
import org.wikidata.query.rdf.tool.wikibase.WikibaseRepository;

public final class Update {
    private static final Logger log = LoggerFactory.getLogger(Update.class);

    private Update() {
    }

    public static void main(String[] args) throws Exception {
        Updater<? extends Change.Batch> updater;
        RdfRepository rdfRepository = null;
        try {
            UpdateOptions options = OptionsUtils.handleOptions(UpdateOptions.class, args);
            WikibaseRepository wikibaseRepository = Update.buildWikibaseRepository(options);
            URI sparqlUri = Update.sparqlUri(options);
            WikibaseUris uris = new WikibaseUris(options.wikibaseHost());
            rdfRepository = new RdfRepository(sparqlUri, uris);
            Change.Source<? extends Change.Batch> changeSource = Update.buildChangeSource(options, rdfRepository, wikibaseRepository);
            updater = Update.createUpdater(options, wikibaseRepository, uris, rdfRepository, changeSource);
        }
        catch (Exception e) {
            log.error("Error during initialization.", (Throwable)e);
            if (rdfRepository != null) {
                rdfRepository.close();
            }
            throw e;
        }
        try (RdfRepository r = rdfRepository;){
            updater.run();
        }
        catch (Exception e) {
            log.error("Error during updater run.", (Throwable)e);
            throw e;
        }
        finally {
            updater.close();
        }
    }

    private static Updater<? extends Change.Batch> createUpdater(UpdateOptions options, WikibaseRepository wikibaseRepository, WikibaseUris uris, RdfRepository rdfRepository, Change.Source<? extends Change.Batch> changeSource) {
        int threads = options.threadCount();
        ThreadFactoryBuilder threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("update %s");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory.build());
        Munger munger = OptionsUtils.mungerFromOptions(options);
        return new Updater<Change.Batch>(changeSource, wikibaseRepository, rdfRepository, munger, executor, options.pollDelay(), uris, options.verify());
    }

    private static URI sparqlUri(UpdateOptions options) {
        URI sparqlUri;
        try {
            sparqlUri = new URI(options.sparqlUrl());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url:  " + options.sparqlUrl(), e);
        }
        return sparqlUri;
    }

    private static Change.Source<? extends Change.Batch> buildChangeSource(UpdateOptions options, RdfRepository rdfRepository, WikibaseRepository wikibaseRepository) {
        long startTime;
        if (options.idrange() != null) {
            long end;
            long start;
            String[] ids = options.idrange().split("-");
            switch (ids.length) {
                case 1: {
                    if (!Character.isDigit(ids[0].charAt(0))) {
                        return new IdListChangeSource(ids, options.batchSize());
                    }
                    end = start = Long.parseLong(ids[0]);
                    break;
                }
                case 2: {
                    start = Long.parseLong(ids[0]);
                    end = Long.parseLong(ids[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid format for --idrange.  Need <start>-<stop>.");
                }
            }
            return IdRangeChangeSource.forItems(start, end, options.batchSize());
        }
        if (options.ids() != null) {
            ArrayList<String> parsedIds = new ArrayList<String>();
            for (String idOpt : options.ids()) {
                if (idOpt.contains(",")) {
                    parsedIds.addAll(Arrays.asList(idOpt.split(",")));
                    continue;
                }
                parsedIds.add(idOpt);
            }
            return new IdListChangeSource(parsedIds.toArray(new String[parsedIds.size()]), options.batchSize());
        }
        if (options.start() != null) {
            try {
                startTime = WikibaseRepository.outputDateFormat().parse(options.start()).getTime();
            }
            catch (ParseException e) {
                try {
                    startTime = WikibaseRepository.inputDateFormat().parse(options.start()).getTime();
                }
                catch (ParseException e2) {
                    throw new IllegalArgumentException("Invalid date: " + options.start(), e2);
                }
            }
        } else {
            log.info("Checking where we left off");
            Date leftOff = rdfRepository.fetchLeftOffTime();
            long minStartTime = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(30L);
            if (leftOff == null) {
                startTime = minStartTime;
                log.info("Defaulting start time to 30 days ago:  {}", (Object)WikibaseRepository.inputDateFormat().format(new Date(startTime)));
            } else {
                if (leftOff.getTime() < minStartTime) {
                    throw new IllegalStateException("RDF store reports the last update time is before the minimum safe poll time.  You will have to reload from scratch or you might have missing data.");
                }
                startTime = leftOff.getTime();
                log.info("Found start time in the RDF store: {}", (Object)WikibaseRepository.inputDateFormat().format(leftOff));
            }
        }
        return new RecentChangesPoller(wikibaseRepository, new Date(startTime), options.batchSize(), options.tailPollerOffset());
    }

    private static WikibaseRepository buildWikibaseRepository(UpdateOptions options) {
        if (options.entityNamespaces() == null) {
            return new WikibaseRepository(options.wikibaseScheme(), options.wikibaseHost());
        }
        String[] strEntityNamespaces = options.entityNamespaces().split(",");
        long[] longEntityNamespaces = new long[strEntityNamespaces.length];
        try {
            for (int i = 0; i < strEntityNamespaces.length; ++i) {
                longEntityNamespaces[i] = Long.parseLong(strEntityNamespaces[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value for --entityNamespaces. Namespace index should be an integer.", e);
        }
        return new WikibaseRepository(options.wikibaseScheme(), options.wikibaseHost(), 0, longEntityNamespaces);
    }
}

