/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.rdf;

import org.apache.commons.lang3.StringUtils;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.query.rdf.tool.rdf.DelegatingRdfHandler;

public class NormalizingRdfHandler
extends DelegatingRdfHandler {
    public NormalizingRdfHandler(RDFHandler next) {
        super(next);
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (uri.contains("ontology-0.0.1")) {
            uri = uri.replace("ontology-0.0.1", "ontology");
        }
        if (uri.contains("ontology-beta")) {
            uri = uri.replace("ontology-beta", "ontology");
        }
        if (uri.startsWith("http://www.wikidata.org/ontology#")) {
            uri = uri.replace("http://www.wikidata.org/ontology#", "http://wikiba.se/ontology#");
        }
        super.handleNamespace(prefix, uri);
    }

    @Override
    public void handleStatement(Statement statement) throws RDFHandlerException {
        Resource subject = statement.getSubject();
        URI predicate = statement.getPredicate();
        Value object = statement.getObject();
        if (subject instanceof URI) {
            subject = this.fixUri((URI)subject);
        }
        predicate = this.fixUri(predicate);
        if (object instanceof URI) {
            object = this.fixUri((URI)object);
        } else if (object instanceof Literal) {
            object = this.fixNumber((Literal)object);
        }
        if (subject != statement.getSubject() || predicate != statement.getPredicate() || object != statement.getObject()) {
            statement = new StatementImpl(subject, predicate, object);
        }
        super.handleStatement(statement);
    }

    private boolean isNumericString(String s) {
        int i = 0;
        if (s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        boolean seenDot = false;
        if (chars[0] == '+' || chars[0] == '-') {
            ++i;
        }
        while (i < s.length()) {
            if (chars[i] == '.') {
                if (seenDot) {
                    return false;
                }
                seenDot = true;
            } else if (chars[i] < '0' || chars[i] > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Value fixNumber(Literal value) {
        if (value.getDatatype().equals((Object)XMLSchema.DECIMAL)) {
            if (!this.isNumericString(value.getLabel())) {
                return new LiteralImpl("0", XMLSchema.DECIMAL);
            }
        } else if (value.getDatatype().equals((Object)XMLSchema.INTEGER) && !this.isNumericString(value.getLabel())) {
            return new LiteralImpl("0", XMLSchema.INTEGER);
        }
        return value;
    }

    private URI fixUri(URI r) {
        String fixed;
        if (r.stringValue().contains("ontology-0.0.1")) {
            r = new URIImpl(r.stringValue().replace("ontology-0.0.1", "ontology"));
        }
        if (r.stringValue().contains("ontology-beta")) {
            r = new URIImpl(r.stringValue().replace("ontology-beta", "ontology"));
        }
        if (r.stringValue().startsWith("http://www.wikidata.org/ontology#")) {
            r = new URIImpl(r.stringValue().replace("http://www.wikidata.org/ontology#", "http://wikiba.se/ontology#"));
        }
        if (!(fixed = StringUtils.replaceEach((String)r.stringValue(), (String[])new String[]{"\n", "|", "\\", "{", "}", "`", "^"}, (String[])new String[]{"", "%7C", "%5C", "%7B", "%7D", "%60", "%5E"})).equals(r.stringValue())) {
            r = new URIImpl(fixed);
        }
        return r;
    }
}

