/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class LiteralImpl
implements Literal {
    private static final long serialVersionUID = -1649571784782592271L;
    private String label;
    private String language;
    private URI datatype;

    protected LiteralImpl() {
    }

    public LiteralImpl(String label) {
        this(label, null, XMLSchema.STRING);
    }

    public LiteralImpl(String label, String language) {
        this(label, language, RDF.LANGSTRING);
    }

    public LiteralImpl(String label, URI datatype) {
        this(label, null, datatype);
    }

    private LiteralImpl(String label, String language, URI datatype) {
        this.setLabel(label);
        if (language != null) {
            this.setLanguage(language.toLowerCase());
        } else if (datatype == null) {
            this.setDatatype(XMLSchema.STRING);
        } else {
            this.setDatatype(datatype);
        }
    }

    protected void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Literal label cannot be null");
        }
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    protected void setLanguage(String language) {
        this.language = language;
        this.setDatatype(RDF.LANGSTRING);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    protected void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Literal) {
            Literal other = (Literal)o;
            if (!this.label.equals(other.getLabel())) {
                return false;
            }
            if (!this.datatype.equals(other.getDatatype())) {
                return false;
            }
            return !(this.language == null ? other.getLanguage() != null : !this.language.equals(other.getLanguage()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.label.length() * 2);
        sb.append('\"');
        sb.append(this.label);
        sb.append('\"');
        if (Literals.isLanguageLiteral(this)) {
            sb.append('@');
            sb.append(this.language);
        } else {
            sb.append("^^<");
            sb.append(this.datatype.toString());
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public String stringValue() {
        return this.label;
    }

    @Override
    public boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean(this.getLabel());
    }

    @Override
    public byte byteValue() {
        return XMLDatatypeUtil.parseByte(this.getLabel());
    }

    @Override
    public short shortValue() {
        return XMLDatatypeUtil.parseShort(this.getLabel());
    }

    @Override
    public int intValue() {
        return XMLDatatypeUtil.parseInt(this.getLabel());
    }

    @Override
    public long longValue() {
        return XMLDatatypeUtil.parseLong(this.getLabel());
    }

    @Override
    public float floatValue() {
        return XMLDatatypeUtil.parseFloat(this.getLabel());
    }

    @Override
    public double doubleValue() {
        return XMLDatatypeUtil.parseDouble(this.getLabel());
    }

    @Override
    public BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger(this.getLabel());
    }

    @Override
    public BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal(this.getLabel());
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar(this.getLabel());
    }
}

