/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.wikibase;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.ContainedException;
import org.wikidata.query.rdf.tool.exception.FatalException;
import org.wikidata.query.rdf.tool.exception.RetryableException;
import org.wikidata.query.rdf.tool.rdf.NormalizingRdfHandler;
import org.wikidata.query.rdf.tool.wikibase.Continue;
import org.wikidata.query.rdf.tool.wikibase.CsrfTokenResponse;
import org.wikidata.query.rdf.tool.wikibase.DeleteResponse;
import org.wikidata.query.rdf.tool.wikibase.EditRequest;
import org.wikidata.query.rdf.tool.wikibase.EditResponse;
import org.wikidata.query.rdf.tool.wikibase.RecentChangeResponse;
import org.wikidata.query.rdf.tool.wikibase.SearchResponse;
import org.wikidata.query.rdf.tool.wikibase.WikibaseResponse;

public class WikibaseRepository
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(WikibaseRepository.class);
    private static final String TIMEOUT_MILLIS = "5000";
    public static final String TIMEOUT_PROPERTY = WikibaseRepository.class.getName() + ".timeout";
    private static final int RETRIES = 3;
    private static final int RETRY_INTERVAL = 500;
    public static final String INPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(100).setMaxConnTotal(100).setRetryHandler(WikibaseRepository.getRetryHandler(3)).setServiceUnavailableRetryStrategy(WikibaseRepository.getRetryStrategy(3, 500)).disableCookieManagement().setUserAgent("Wikidata Query Service Updater").build();
    private final int requestTimeout = Integer.parseInt(System.getProperty(TIMEOUT_PROPERTY, "5000"));
    private final RequestConfig configWithTimeout = RequestConfig.custom().setSocketTimeout(this.requestTimeout).setConnectTimeout(this.requestTimeout).setConnectionRequestTimeout(this.requestTimeout).build();
    private final Uris uris;
    private final ObjectMapper mapper = new ObjectMapper();

    public WikibaseRepository(String scheme, String host) {
        this.uris = new Uris(scheme, host);
        this.configureObjectMapper(this.mapper);
    }

    public WikibaseRepository(String scheme, String host, int port) {
        this.uris = new Uris(scheme, host, port);
        this.configureObjectMapper(this.mapper);
    }

    public WikibaseRepository(String scheme, String host, int port, long[] entityNamespaces) {
        this.uris = new Uris(scheme, host, port, entityNamespaces);
        this.configureObjectMapper(this.mapper);
    }

    private void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static ServiceUnavailableRetryStrategy getRetryStrategy(final int max, final int interval) {
        return new ServiceUnavailableRetryStrategy(){

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                return executionCount <= max && (response.getStatusLine().getStatusCode() == 503 || response.getStatusLine().getStatusCode() == 429);
            }

            @Override
            public long getRetryInterval() {
                return interval;
            }
        };
    }

    private static HttpRequestRetryHandler getRetryHandler(int max) {
        return (exception, executionCount, context) -> {
            boolean idempotent;
            log.debug("Exception in attempt {}", (Object)executionCount, (Object)exception);
            if (executionCount >= max) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return true;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException) {
                return true;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt(context);
            HttpRequest request = clientContext.getRequest();
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
    }

    public RecentChangeResponse fetchRecentChangesByTime(Date nextStartTime, int batchSize) throws RetryableException {
        return this.fetchRecentChanges(nextStartTime, null, batchSize);
    }

    public RecentChangeResponse fetchRecentChanges(Date nextStartTime, Continue lastContinue, int batchSize) throws RetryableException {
        URI uri = this.uris.recentChanges(nextStartTime, lastContinue, batchSize);
        log.debug("Polling for changes from {}", (Object)uri);
        HttpGet request = new HttpGet(uri);
        request.setConfig(this.configWithTimeout);
        try {
            return this.checkApi(this.getJson(request, RecentChangeResponse.class));
        }
        catch (SocketException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RetryableException("Error fetching recent changes", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Statement> fetchRdfForEntity(String entityId) throws RetryableException {
        URI uri = this.uris.rdf(entityId);
        long start = System.currentTimeMillis();
        log.debug("Fetching rdf from {}", (Object)uri);
        RDFParser parser = Rio.createParser(RDFFormat.TURTLE);
        StatementCollector collector = new StatementCollector();
        parser.setRDFHandler(new NormalizingRdfHandler(collector));
        HttpGet request = new HttpGet(uri);
        request.setConfig(this.configWithTimeout);
        try (CloseableHttpResponse response = this.client.execute(request);){
            if (response.getStatusLine().getStatusCode() == 404) {
                List<Statement> list = Collections.emptyList();
                return list;
            }
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new ContainedException("Unexpected status code fetching RDF for " + uri + ":  " + response.getStatusLine().getStatusCode());
            }
            parser.parse(new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8), uri.toString());
        }
        catch (SocketException | UnknownHostException | SSLHandshakeException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RetryableException("Error fetching RDF for " + uri, e);
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new ContainedException("RDF parsing error for " + uri, e);
        }
        log.debug("Done in {} ms", (Object)(System.currentTimeMillis() - start));
        return collector.getStatements();
    }

    public String firstEntityIdForLabelStartingWith(String label, String language, String type) throws RetryableException {
        URI uri = this.uris.searchForLabel(label, language, type);
        log.debug("Searching for entity using {}", (Object)uri);
        try {
            SearchResponse result = this.checkApi(this.getJson(new HttpGet(uri), SearchResponse.class));
            List<SearchResponse.SearchResult> resultList = result.getSearch();
            if (resultList.isEmpty()) {
                return null;
            }
            return resultList.get(0).getId();
        }
        catch (IOException e) {
            throw new RetryableException("Error searching for page", e);
        }
    }

    public String setLabel(String entityId, String type, String label, String language) throws RetryableException {
        String datatype = type.equals("property") ? "string" : null;
        EditRequest data = new EditRequest(datatype, ImmutableMap.of(language, new EditRequest.Label(language, label)));
        try {
            URI uri = this.uris.edit(entityId, type, this.mapper.writeValueAsString(data));
            log.debug("Editing entity using {}", (Object)uri);
            EditResponse result = this.checkApi(this.getJson(this.postWithToken(uri), EditResponse.class));
            return result.getEntity().getId();
        }
        catch (IOException e) {
            throw new RetryableException("Error adding page", e);
        }
    }

    public void delete(String entityId) throws RetryableException {
        URI uri = this.uris.delete(entityId);
        log.debug("Deleting entity {} using {}", (Object)entityId, (Object)uri);
        try {
            DeleteResponse result = this.checkApi(this.getJson(this.postWithToken(uri), DeleteResponse.class));
            log.debug("Deleted: {}", (Object)result);
        }
        catch (IOException e) {
            throw new RetryableException("Error deleting page", e);
        }
    }

    private HttpPost postWithToken(URI uri) throws IOException {
        HttpPost request = new HttpPost(uri);
        ArrayList<BasicNameValuePair> entity = new ArrayList<BasicNameValuePair>();
        entity.add(new BasicNameValuePair("token", this.csrfToken()));
        request.setEntity(new UrlEncodedFormEntity(entity, Consts.UTF_8));
        return request;
    }

    private String csrfToken() throws IOException {
        URI uri = this.uris.csrfToken();
        log.debug("Fetching csrf token from {}", (Object)uri);
        return this.getJson(new HttpGet(uri), CsrfTokenResponse.class).getQuery().getTokens().getCsrfToken();
    }

    private <T extends WikibaseResponse> T getJson(HttpRequestBase request, Class<T> valueType) throws IOException {
        try (CloseableHttpResponse response = this.client.execute(request);){
            WikibaseResponse wikibaseResponse = (WikibaseResponse)this.mapper.readValue(response.getEntity().getContent(), valueType);
            return (T)wikibaseResponse;
        }
    }

    private <T extends WikibaseResponse> T checkApi(T response) throws RetryableException {
        Object error = response.getError();
        if (error != null) {
            throw new RetryableException("Error result from Mediawiki:  " + error);
        }
        return response;
    }

    public boolean isEntityNamespace(long namespace) {
        return ArrayUtils.contains(this.uris.getEntityNamespaces(), namespace);
    }

    public boolean isValidEntity(String name) {
        return name.matches("^[A-Za-z0-9:]+$");
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public static DateFormat outputDateFormat() {
        return WikibaseRepository.utc(new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT));
    }

    public static DateFormat inputDateFormat() {
        return WikibaseRepository.utc(new SimpleDateFormat(INPUT_DATE_FORMAT, Locale.ROOT));
    }

    private static DateFormat utc(DateFormat df) {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"}, justification="low priority to fix")
    public Change getChangeFromContinue(Continue nextContinue) throws ParseException {
        if (nextContinue == null) {
            return null;
        }
        String[] parts = nextContinue.getRcContinue().split("\\|");
        return new Change("DUMMY", -1L, WikibaseRepository.outputDateFormat().parse(parts[0]), Long.parseLong(parts[1]));
    }

    public static class Uris {
        private final String scheme;
        private final String host;
        private final int port;
        private long[] entityNamespaces = new long[]{0L, 120L};

        public Uris(String scheme, String host) {
            this.scheme = scheme;
            this.host = host;
            this.port = 0;
        }

        public Uris(String scheme, String host, int port) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="minor enough")
        public Uris(String scheme, String host, int port, long[] entityNamespaces) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.entityNamespaces = entityNamespaces;
        }

        public URI recentChanges(Date startTime, Continue continueObject, int batchSize) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "query");
            builder.addParameter("list", "recentchanges");
            builder.addParameter("rcdir", "newer");
            builder.addParameter("rcprop", "title|ids|timestamp");
            builder.addParameter("rcnamespace", this.getEntityNamespacesString("|"));
            builder.addParameter("rclimit", Integer.toString(batchSize));
            if (continueObject == null) {
                builder.addParameter("continue", "");
                builder.addParameter("rcstart", WikibaseRepository.outputDateFormat().format(startTime));
            } else {
                builder.addParameter("continue", continueObject.getContinue());
                builder.addParameter("rccontinue", continueObject.getRcContinue());
            }
            return this.build(builder);
        }

        public URI rdf(String entityId) {
            URIBuilder builder = this.builder();
            builder.setPath(String.format(Locale.ROOT, "/wiki/Special:EntityData/%s.ttl", entityId));
            builder.addParameter("nocache", Long.toString(new Date().getTime()));
            builder.addParameter("flavor", "dump");
            return this.build(builder);
        }

        public URI csrfToken() {
            URIBuilder builder = this.apiBuilder();
            builder.setParameter("action", "query");
            builder.setParameter("meta", "tokens");
            builder.setParameter("continue", "");
            return this.build(builder);
        }

        public URI searchForLabel(String label, String language, String type) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "wbsearchentities");
            builder.addParameter("search", label);
            builder.addParameter("language", language);
            builder.addParameter("type", type);
            return this.build(builder);
        }

        public URI edit(String entityId, String newType, String data) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "wbeditentity");
            if (entityId != null) {
                builder.addParameter("id", entityId);
            } else {
                builder.addParameter("new", newType);
            }
            builder.addParameter("data", data);
            return this.build(builder);
        }

        public URI delete(String entityId) {
            URIBuilder builder = this.apiBuilder();
            builder.addParameter("action", "delete");
            builder.addParameter("title", entityId);
            return this.build(builder);
        }

        private URIBuilder apiBuilder() {
            URIBuilder builder = this.builder();
            builder.setPath("/w/api.php");
            builder.addParameter("format", "json");
            return builder;
        }

        public URIBuilder builder() {
            URIBuilder builder = new URIBuilder();
            builder.setHost(this.host);
            builder.setScheme(this.scheme);
            if (this.port != 0) {
                builder.setPort(this.port);
            }
            return builder;
        }

        private URI build(URIBuilder builder) {
            try {
                return builder.build();
            }
            catch (URISyntaxException e) {
                throw new FatalException("Unable to build url!?", e);
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getScheme() {
            return this.scheme;
        }

        private long[] getEntityNamespaces() {
            return this.entityNamespaces;
        }

        private String getEntityNamespacesString(String delimiter) {
            return Longs.join(delimiter, this.entityNamespaces);
        }
    }
}

