/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.query.rdf.tool.change;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.Locale;
import org.wikidata.query.rdf.tool.change.Change;
import org.wikidata.query.rdf.tool.exception.RetryableException;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="spotbug limitation: https://github.com/spotbugs/spotbugs/issues/463")
public class IdRangeChangeSource
implements Change.Source<Batch> {
    private final String format;
    private final long start;
    private final long stop;
    private final long batchSize;

    public static IdRangeChangeSource forItems(long start, long stop, long batchSize) {
        return new IdRangeChangeSource("Q%s", start, stop, batchSize);
    }

    public IdRangeChangeSource(String format, long start, long stop, long batchSize) {
        this.format = format;
        this.start = start;
        this.stop = stop;
        this.batchSize = batchSize;
    }

    @Override
    public Batch firstBatch() throws RetryableException {
        return this.batch(this.start);
    }

    @Override
    public Batch nextBatch(Batch lastBatch) throws RetryableException {
        return this.batch(lastBatch.nextStart);
    }

    private Batch batch(long batchStart) {
        long batchStop = Math.min(batchStart + this.batchSize, this.stop + 1L);
        ImmutableList.Builder changes = ImmutableList.builder();
        for (long id = batchStart; id < batchStop; ++id) {
            changes.add((Object)new Change(String.format(Locale.ROOT, this.format, id), -1L, null, id));
        }
        return new Batch(changes.build(), batchStop - batchStart, batchStop);
    }

    public final class Batch
    extends Change.Batch.AbstractDefaultImplementation {
        private final long nextStart;

        private Batch(ImmutableList<Change> changes, long advanced, long nextStart) {
            super(changes, advanced, nextStart - 1L);
            this.nextStart = nextStart;
        }

        @Override
        public String advancedUnits() {
            return "ids";
        }

        @Override
        public boolean last() {
            return this.nextStart > IdRangeChangeSource.this.stop;
        }

        @Override
        public Date leftOffDate() {
            return null;
        }
    }
}

